/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import run.wj.commons.utils.ObjectUtils;

public class ResponseUtil {
    public static ResponseEntity<byte[]> fileDownload(InputStream in, String fileFullName) {
        if (ObjectUtils.isEmpty(in)) {
            return null;
        }
        byte[] bytes = new byte[]{};
        try (InputStream tmp = in;){
            bytes = IOUtils.toByteArray(tmp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ResponseEntity<byte[]> response = ResponseUtil.fileDownload(bytes, fileFullName);
        return response;
    }

    public static ResponseEntity<byte[]> fileInline(InputStream in, String fileFullName) {
        if (ObjectUtils.isEmpty(in)) {
            return null;
        }
        byte[] bytes = new byte[]{};
        try (InputStream tmp = in;){
            bytes = IOUtils.toByteArray(tmp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ResponseEntity<byte[]> response = ResponseUtil.fileInline(bytes, fileFullName);
        return response;
    }

    public static ResponseEntity<byte[]> fileDownload(byte[] body2, String fileFullName) {
        try {
            fileFullName = new String(fileFullName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment;filename=" + fileFullName);
        headers.add("Content-Length", "" + body2.length);
        headers.add("Content-Type", "application/" + FilenameUtils.getExtension(fileFullName));
        HttpStatus statusCode = HttpStatus.OK;
        return new ResponseEntity<byte[]>(body2, (MultiValueMap<String, String>)headers, statusCode);
    }

    public static ResponseEntity<byte[]> fileInline(byte[] body2, String fileFullName) {
        try {
            fileFullName = new String(fileFullName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "inline;filename=" + fileFullName);
        headers.add("Content-Length", "" + body2.length);
        headers.add("Content-Type", "application/" + FilenameUtils.getExtension(fileFullName));
        HttpStatus statusCode = HttpStatus.OK;
        return new ResponseEntity<byte[]>(body2, (MultiValueMap<String, String>)headers, statusCode);
    }
}

