/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.wj.commons.utils.GetObj;

public class StreamUtil {
    private final Logger log = LoggerFactory.getLogger(StreamUtil.class);

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static <T> T getObj(GetObj getObj, Class<T> def) {
        try {
            Object o = getObj.exec();
            if (def.equals(String.class)) {
                return (T)String.valueOf(o);
            }
            if (def.equals(Integer.class)) {
                return (T)Integer.valueOf(String.valueOf(o));
            }
            if (def.equals(Long.class)) {
                return (T)Long.valueOf(String.valueOf(o));
            }
            if (def.equals(Short.class)) {
                return (T)Short.valueOf(String.valueOf(o));
            }
            if (def.equals(Boolean.class)) {
                return (T)Boolean.valueOf(String.valueOf(o));
            }
            return (T)o;
        }
        catch (Exception e) {
            if (def.equals(String.class)) {
                return (T)String.valueOf("");
            }
            if (def.equals(Integer.class)) {
                return (T)Integer.valueOf(0);
            }
            if (def.equals(Long.class)) {
                return (T)Long.valueOf(0L);
            }
            if (def.equals(Short.class)) {
                return (T)Short.valueOf((short)0);
            }
            if (def.equals(Boolean.class)) {
                return (T)Boolean.valueOf(false);
            }
            return (T)def;
        }
    }

    public static String join(List<String> set, String delimiter) {
        return set.stream().collect(Collectors.joining(delimiter));
    }

    public static String join(Set<String> set, String delimiter) {
        return set.stream().collect(Collectors.joining(delimiter));
    }

    public static void main(String[] args) {
        String s = "[{\"id\":826963198,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/1.png\",\"nickName\":\"17826829640\"},{\"id\":826964333,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/1.png\",\"nickName\":\"11\"},{\"id\":826964348,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/1.png\",\"nickName\":\"22\"},{\"id\":826964380,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/1.png\",\"nickName\":\"33\"},{\"id\":826964382,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/2.png\",\"nickName\":\"5\"},{\"id\":826964384,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/8.png\",\"nickName\":\"44\"},{\"id\":826964386,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/8.png\",\"nickName\":\"6\"},{\"id\":826964393,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/9.png\",\"nickName\":\"7\"},{\"id\":826964412,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/6.png\",\"nickName\":\"8\"},{\"id\":826964415,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/dzt/pub/tool.png\",\"nickName\":\"888888\"},{\"id\":826964420,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/8.png\",\"nickName\":\"10\"},{\"id\":826964435,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/8.png\",\"nickName\":\"13\"},{\"id\":826964612,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/dzt/pub/1551171266817.png\",\"nickName\":\"hahah\"},{\"id\":826964874,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/8.png\",\"nickName\":\"13333333333\"},{\"id\":826965533,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/2.png\",\"nickName\":\"15605887777\"},{\"id\":826965544,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/9.png\",\"nickName\":\"17826829639\"},{\"id\":826965567,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/8.png\",\"nickName\":\"16666666666\"},{\"id\":826965570,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/2.png\",\"nickName\":\"15555555555\"},{\"id\":826965636,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/8.png\",\"nickName\":\"18778877787\"},{\"id\":826965645,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/11.png\",\"nickName\":\"10000000000\"},{\"id\":826965654,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/3.png\",\"nickName\":\"19786787978\"},{\"id\":826965934,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/4.png\",\"nickName\":\"13435344646\"},{\"id\":826965983,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/4.png\",\"nickName\":\"13250828232\"},{\"id\":826966097,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/6.png\",\"nickName\":\"15675766556\"},{\"id\":826966152,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/11.png\",\"nickName\":\"\u7528\u623715605887372\"},{\"id\":826966155,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/6.png\",\"nickName\":\"\u7528\u623713725327643\"},{\"id\":826966158,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/8.png\",\"nickName\":\"\u7528\u623710923746999\"},{\"id\":826966161,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/5.png\",\"nickName\":\"\u7528\u623712232000083\"},{\"id\":826966164,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/2.png\",\"nickName\":\"\u7528\u623712089777778\"},{\"id\":826966167,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/6.png\",\"nickName\":\"\u7528\u623719666778598\"},{\"id\":264964293902,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/dzt/pub/1551171068980.png\",\"nickName\":\"gagag\"},{\"id\":264964295407,\"avatar\":\"https://aoshu-1255861069.cos.ap-shanghai.myqcloud.com/local/defAvatar/5.png\",\"nickName\":\"\u7528\u623717605883305\"}]";
        ArrayList<Long> ids = new ArrayList<Long>();
        JSONArray objects = JSONArray.parseArray(s, new Feature[0]);
        for (int i2 = 0; i2 < objects.size(); ++i2) {
            Long id = objects.getJSONObject(i2).getLong("id");
            ids.add(id);
        }
        String collect = ids.stream().map(String::valueOf).collect(Collectors.joining(","));
        System.out.println(collect);
    }
}

