/*
 * Decompiled with CFR 0.152.
 */
package run.wj.ddns;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.alidns.model.v20150109.AddDomainRecordRequest;
import com.aliyuncs.alidns.model.v20150109.AddDomainRecordResponse;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordsRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordsResponse;
import com.aliyuncs.alidns.model.v20150109.UpdateDomainRecordRequest;
import com.aliyuncs.alidns.model.v20150109.UpdateDomainRecordResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.CollectionUtils;
import run.wj.ddns.model.Config;

public class DDNSMain {
    private static final Logger log = LogManager.getLogger(DDNSMain.class);

    private static void add(Config config, String ip) {
        String[] dnsRrs;
        for (String dnsRr : dnsRrs = config.getDnsRr()) {
            AddDomainRecordRequest request = new AddDomainRecordRequest();
            request.setValue(ip);
            request.setType(config.getDnsType());
            request.setRR(dnsRr);
            request.setDomainName(config.getDnsDomain());
            DefaultAcsClient client = new DefaultAcsClient(DefaultProfile.getProfile(config.getAliyunRegionId(), config.getAliyunAccessKeyId(), config.getAliyunAccessKeySecret()));
            try {
                AddDomainRecordResponse response = client.getAcsResponse(request);
                log.info(new Gson().toJson(response));
            }
            catch (ClientException e) {
                log.error("\u6dfb\u52a0\u5f02\u5e38", e);
            }
        }
    }

    private static IAcsClient getClient(Config config) {
        DefaultAcsClient client = new DefaultAcsClient(DefaultProfile.getProfile(config.getAliyunRegionId(), config.getAliyunAccessKeyId(), config.getAliyunAccessKeySecret()));
        return client;
    }

    private static Config getConfig() {
        File property = new File(System.getProperty("user.dir") + File.separator + "conf.properties");
        Properties properties = new Config().toProperties();
        if (!property.exists()) {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(property);
                properties.store(outputStream, null);
            }
            catch (Exception ex) {
                try {
                    assert (outputStream != null);
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new Config();
        }
        try {
            properties = PropertiesLoaderUtils.loadProperties(new UrlResource(property.toURI().toURL()));
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage());
        }
        return new Config(properties);
    }

    public static void main(String[] args) {
        final Config properties = DDNSMain.getConfig();
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    DDNSMain.updateDdns(properties);
                }
                catch (Exception e) {
                    log.error("\u5f02\u5e38\uff01", e);
                }
            }
        };
        timer.schedule(timerTask, new Date(), Long.parseLong(properties.getTimerPeriodSecond()) * 1000L);
    }

    private static void updateDdns(Config config) throws Exception {
        DDNSMain ddns = new DDNSMain();
        String currentHostIP = ddns.getCurrentHostIP(config);
        for (String dnsRr : config.getDnsRr()) {
            DescribeDomainRecordsRequest describeDomainRecordsRequest = new DescribeDomainRecordsRequest();
            describeDomainRecordsRequest.setDomainName(config.getDnsDomain());
            describeDomainRecordsRequest.setRRKeyWord(dnsRr);
            describeDomainRecordsRequest.setType(config.getDnsType());
            DescribeDomainRecordsResponse describeDomainRecordsResponse = ddns.describeDomainRecords(describeDomainRecordsRequest, DDNSMain.getClient(config));
            List<DescribeDomainRecordsResponse.Record> domainRecords = describeDomainRecordsResponse.getDomainRecords();
            if (CollectionUtils.isEmpty(domainRecords)) {
                DDNSMain.add(config, currentHostIP);
                continue;
            }
            for (DescribeDomainRecordsResponse.Record record : domainRecords) {
                String recordId = record.getRecordId();
                String ip = record.getValue();
                log.info("\u7c7b\u578b\uff1a" + config.getDnsType() + " \u57df\u540d\uff1a" + dnsRr + "." + config.getDnsDomain() + " \u516c\u7f51ip\uff1a" + currentHostIP);
                if (currentHostIP.equals(ip)) continue;
                UpdateDomainRecordRequest updateDomainRecordRequest = new UpdateDomainRecordRequest();
                updateDomainRecordRequest.setRR(dnsRr);
                updateDomainRecordRequest.setRecordId(recordId);
                updateDomainRecordRequest.setValue(currentHostIP);
                updateDomainRecordRequest.setType(config.getDnsType());
                ddns.updateDomainRecord(updateDomainRecordRequest, DDNSMain.getClient(config));
            }
        }
    }

    private DescribeDomainRecordsResponse describeDomainRecords(DescribeDomainRecordsRequest request, IAcsClient client) throws ClientException {
        return client.getAcsResponse(request);
    }

    private String getCurrentHostIP(Config config) {
        String ipJson;
        HttpGet httpGet = new HttpGet(config.getUrl());
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            ipJson = EntityUtils.toString(httpClient.execute(httpGet).getEntity(), Charset.defaultCharset());
            HashMap hashMap = new Gson().fromJson(ipJson, HashMap.class);
            ipJson = String.valueOf(hashMap.get("ip"));
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u516c\u7f51ip\u9519\u8bef\uff01" + e.getLocalizedMessage());
            return "";
        }
        if (!ipJson.contains(".")) {
            return "";
        }
        return ipJson;
    }

    private void updateDomainRecord(UpdateDomainRecordRequest request, IAcsClient client) {
        try {
            UpdateDomainRecordResponse res = client.getAcsResponse(request);
            log.info(new Gson().toJson(res));
        }
        catch (ClientException e) {
            log.error("\u4fee\u6539\u9519\u8bef", e);
        }
    }
}

