/*
 * Decompiled with CFR 0.152.
 */
package school.mjc.parser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import school.mjc.parser.predicate.Dsl;

public class Asserts {
    public static void assertNoImports(CompilationUnit parsed) {
        Assertions.assertEquals((int)0, (int)parsed.findAll(ImportDeclaration.class).size(), (String)"Please don't use 'import' statements");
    }

    public static void assertNoInitializationBlocks(CompilationUnit parsed) {
        Assertions.assertEquals((int)0, (int)parsed.findAll(InitializerDeclaration.class).size(), (String)"Please don't use declaration blocks statements");
    }

    public static void assertNoMethodsExceptMain(CompilationUnit parsed) {
        Assertions.assertEquals((int)0, (int)parsed.findAll(MethodDeclaration.class, Dsl.main().negate()).size(), (String)"Please don't use any methods except main");
    }

    public static void assertNoClassesExceptTopLevel(CompilationUnit parsed, String name) {
        Assertions.assertEquals((int)0, (int)parsed.findAll(ClassOrInterfaceDeclaration.class, Dsl.topLevelClass(name).negate()).size(), (String)"Please don't create any classes except for the top-level class");
    }

    public static void assertVariablesPrinted(CompilationUnit parsed, String ... names) {
        Set printedVariables = parsed.findAll(MethodCallExpr.class, (Predicate)Dsl.sout()).stream().flatMap(mce -> mce.getArguments().stream()).flatMap(mce -> mce.findAll(NameExpr.class).stream()).map(ne -> ne.getName().getIdentifier()).collect(Collectors.toCollection(HashSet::new));
        Assertions.assertTrue((boolean)printedVariables.containsAll(Arrays.asList(names)), (String)"Not all variables are printed");
    }
}

