/*
 * Decompiled with CFR 0.152.
 */
package school.mjc.parser.predicate;

import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;

public class BinaryExpressionPredicate
implements Predicate<Expression> {
    private static final Set<BinaryExpr.Operator> COMMUTATIVE_OPERATORS = EnumSet.of(BinaryExpr.Operator.BINARY_OR, BinaryExpr.Operator.BINARY_AND, BinaryExpr.Operator.XOR, BinaryExpr.Operator.PLUS, BinaryExpr.Operator.MULTIPLY);
    private final BinaryExpr.Operator operator;
    private final Predicate<Expression> left;
    private final Predicate<Expression> right;
    private boolean strict = true;

    public BinaryExpressionPredicate(Predicate<Expression> left, BinaryExpr.Operator operator, Predicate<Expression> right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean test(Expression expression) {
        if ((expression.isBinaryExpr() || expression.isEnclosedExpr()) && expression.getParentNode().isPresent() && expression.getParentNode().get() instanceof EnclosedExpr) {
            return false;
        }
        while (expression.isEnclosedExpr()) {
            expression = expression.asEnclosedExpr().getInner();
        }
        if (!expression.isBinaryExpr()) {
            return false;
        }
        return this.checkBinaryExpression(expression.asBinaryExpr());
    }

    public boolean checkBinaryExpression(BinaryExpr binaryExpr) {
        if (binaryExpr.getOperator() != this.operator) {
            return false;
        }
        return this.checkOperands(binaryExpr);
    }

    private boolean checkOperands(BinaryExpr binaryExpr) {
        if (this.strict || !COMMUTATIVE_OPERATORS.contains(this.operator)) {
            return this.left.test(binaryExpr.getLeft()) && this.right.test(binaryExpr.getRight());
        }
        return this.left.test(binaryExpr.getLeft()) && this.right.test(binaryExpr.getRight()) || this.right.test(binaryExpr.getLeft()) && this.left.test(binaryExpr.getRight());
    }

    public BinaryExpressionPredicate notStrict() {
        this.strict = false;
        return this;
    }
}

