/*
 * Decompiled with CFR 0.152.
 */
package school.mjc.parser.predicate;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import java.util.function.Predicate;
import school.mjc.parser.CollectionUtil;
import school.mjc.parser.predicate.BinaryExpressionPredicate;
import school.mjc.parser.predicate.MainPredicate;
import school.mjc.parser.predicate.SoutPredicate;
import school.mjc.parser.predicate.TopLevelClassPredicate;
import school.mjc.parser.predicate.VariableDeclarationPredicate;

public class Dsl {
    public static Predicate<Expression> intLiteral(Integer number) {
        return expression -> expression.isIntegerLiteralExpr() && expression.asIntegerLiteralExpr().getValue().equals(number.toString());
    }

    public static Predicate<Expression> doubleLiteral(Double number) {
        return expression -> expression.isDoubleLiteralExpr() && Double.valueOf(expression.asDoubleLiteralExpr().getValue()).equals(number);
    }

    public static Predicate<Expression> longLiteral(Long number) {
        return expression -> {
            if (!expression.isLongLiteralExpr()) {
                return false;
            }
            String stringValue = expression.asLongLiteralExpr().getValue();
            if (stringValue.toUpperCase().endsWith("L")) {
                stringValue = stringValue.substring(0, stringValue.length() - 1);
            }
            return number == Long.parseLong(stringValue);
        };
    }

    public static Predicate<Expression> stringLiteral(String text) {
        return expression -> expression.isStringLiteralExpr() && expression.asStringLiteralExpr().getValue().equals(text);
    }

    public static Predicate<Expression> variableRef(String name) {
        return expression -> expression.isNameExpr() && expression.asNameExpr().getName().getIdentifier().equals(name);
    }

    public static Predicate<Expression> anyVariableRef() {
        return Expression::isNameExpr;
    }

    public static VariableDeclarationPredicate declaration() {
        return Dsl.declaration(null);
    }

    public static VariableDeclarationPredicate declaration(String name) {
        return new VariableDeclarationPredicate(name);
    }

    public static BinaryExpressionPredicate binaryExpression(Predicate<Expression> left, BinaryExpr.Operator operator, Predicate<Expression> right) {
        return new BinaryExpressionPredicate(left, operator, right);
    }

    public static BinaryExpressionPredicate binaryExpressionNotStrict(Predicate<Expression> left, BinaryExpr.Operator operator, Predicate<Expression> right) {
        return Dsl.binaryExpression(left, operator, right).notStrict();
    }

    public static SoutPredicate sout() {
        return new SoutPredicate();
    }

    public static MainPredicate main() {
        return new MainPredicate();
    }

    public static TopLevelClassPredicate topLevelClass(String name) {
        return new TopLevelClassPredicate(name);
    }

    public static MethodDeclaration findMain(CompilationUnit compilationUnit) {
        return (MethodDeclaration)CollectionUtil.getSingle(compilationUnit.findAll(MethodDeclaration.class, (Predicate)new MainPredicate()), i -> "Expected to find single 'public static void main(String[] args)' method, found " + i);
    }
}

