/*
 * Decompiled with CFR 0.152.
 */
package school.mjc.test;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import school.mjc.test.ArgumentResolver;

@ExtendWith(value={ArgumentResolver.class})
public class BaseIOTest {
    protected final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    protected final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    protected final PrintStream originalOut = System.out;
    protected final PrintStream originalErr = System.err;

    @BeforeEach
    public void setUpStreams() {
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
    }

    @AfterEach
    public void restoreStreams() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    protected void assertOutEquals(String expected) {
        Assertions.assertEquals((Object)expected, (Object)this.updateLineSpliterators(this.outContent.toString(StandardCharsets.UTF_8)));
    }

    protected String updateLineSpliterators(String initial) {
        return initial.replaceAll("(\n\r)|(\r\n)|(\r)", "\n");
    }

    protected List<String> getOutput() {
        return Arrays.asList(this.outContent.toString(StandardCharsets.UTF_8).split("(\n\r)|(\r\n)|\r|\n"));
    }

    protected void assertOutput(String ... expected) {
        this.assertOutput((List<String> output) -> "Program output didn't match expected", expected);
    }

    protected void assertOutput(Function<List<String>, String> errorMessageFunction, String ... expected) {
        List<String> output = this.getOutput();
        Assertions.assertEquals(Arrays.asList(expected), output, () -> (String)errorMessageFunction.apply(output));
    }

    protected void assertOutputIgnoreLineDelimiters(String expected) {
        this.assertOutputIgnoreLineDelimiters(actualInput -> "Program output didn't match expected", expected);
    }

    protected void assertOutputIgnoreLineDelimiters(Function<String, String> errorMessageFunction, String expected) {
        String actualOutput = String.join((CharSequence)"", this.getOutput());
        Assertions.assertEquals((Object)expected, (Object)actualOutput, () -> (String)errorMessageFunction.apply(actualOutput));
    }
}

