/*
 * Decompiled with CFR 0.152.
 */
package se.akerfeldt.okhttp.signpost;

import com.squareup.okhttp.Request;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import oauth.signpost.http.HttpRequest;
import okio.Buffer;
import okio.BufferedSink;

public class OkHttpRequestAdapter
implements HttpRequest {
    private Request request;

    public OkHttpRequestAdapter(Request request) {
        this.request = request;
    }

    public Map<String, String> getAllHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : this.request.headers().names()) {
            headers.put(key, this.request.header(key));
        }
        return headers;
    }

    public String getContentType() {
        if (this.request.body() != null) {
            return this.request.body().contentType() != null ? this.request.body().contentType().toString() : null;
        }
        return null;
    }

    public String getHeader(String key) {
        return this.request.header(key);
    }

    public InputStream getMessagePayload() throws IOException {
        if (this.request.body() == null) {
            return null;
        }
        Buffer buf = new Buffer();
        this.request.body().writeTo((BufferedSink)buf);
        return buf.inputStream();
    }

    public String getMethod() {
        return this.request.method();
    }

    public String getRequestUrl() {
        return this.request.urlString();
    }

    public void setHeader(String key, String value) {
        this.request = this.request.newBuilder().header(key, value).build();
    }

    public void setRequestUrl(String url) {
        this.request = this.request.newBuilder().url(url).build();
    }

    public Object unwrap() {
        return this.request;
    }
}

