/*
 * Decompiled with CFR 0.152.
 */
package se.akerfeldt.okhttp.signpost;

import oauth.signpost.AbstractOAuthProvider;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.http.HttpResponse;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import se.akerfeldt.okhttp.signpost.OkHttpRequestAdapter;
import se.akerfeldt.okhttp.signpost.OkHttpResponseAdapter;

public class OkHttpOAuthProvider
extends AbstractOAuthProvider {
    private OkHttpClient okHttpClient;

    public OkHttpOAuthProvider(String requestTokenEndpointUrl, String accessTokenEndpointUrl, String authorizationWebsiteUrl) {
        super(requestTokenEndpointUrl, accessTokenEndpointUrl, authorizationWebsiteUrl);
        this.okHttpClient = new OkHttpClient();
    }

    public OkHttpOAuthProvider(String requestTokenEndpointUrl, String accessTokenEndpointUrl, String authorizationWebsiteUrl, OkHttpClient okHttpClient) {
        super(requestTokenEndpointUrl, accessTokenEndpointUrl, authorizationWebsiteUrl);
        this.okHttpClient = okHttpClient;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    protected HttpRequest createRequest(String endpointUrl) throws Exception {
        Request request = new Request.Builder().url(endpointUrl).build();
        return new OkHttpRequestAdapter(request);
    }

    protected HttpResponse sendRequest(HttpRequest request) throws Exception {
        Response response = this.okHttpClient.newCall((Request)request.unwrap()).execute();
        return new OkHttpResponseAdapter(response);
    }
}

