/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.snapshot.internal.assertions;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.snapshot.api.UpdateMode;
import org.assertj.snapshot.internal.utils.FileUtils;
import org.assertj.snapshot.internal.utils.FileUtilsImpl;
import org.assertj.snapshot.internal.utils.JSONUtils;
import org.assertj.snapshot.internal.utils.SourceCodeLocator;
import org.assertj.snapshot.internal.utils.TestCaseFinder;

public class InternalFileAssertions {
    private static final String SNAPSHOTS_DIR = "snapshots";

    public static void assertEqual(Object actual, UpdateMode updateMode) {
        boolean shouldUpdate;
        TestCaseFinder.AssertingTestCase testCase = TestCaseFinder.getTestCase();
        File sourceFolderOfTestCase = SourceCodeLocator.getSourceFolder(testCase.getClassName(), testCase.getFile());
        Path snapshotsFolder = sourceFolderOfTestCase.toPath().resolve(SNAPSHOTS_DIR);
        FileUtils fileUtils = FileUtilsImpl.create();
        if (!fileUtils.pathExists(snapshotsFolder)) {
            fileUtils.createDirs(snapshotsFolder);
        }
        Path snapshotFile = snapshotsFolder.resolve(testCase.getClassName() + "_" + testCase.getMethodName() + ".snapshot.json");
        Optional<String> snapshotOpt = fileUtils.findFileContent(snapshotFile);
        String actualJson = JSONUtils.prettyPrint(actual);
        boolean expectedDoesNotExist = !snapshotOpt.isPresent();
        boolean bl = shouldUpdate = expectedDoesNotExist && updateMode == UpdateMode.UPDATE_IF_NO_PREVIOUS_SNAPSHOT || updateMode == UpdateMode.UPDATE_ALWAYS;
        if (shouldUpdate) {
            fileUtils.writeFileContent(snapshotFile, actualJson);
        } else {
            String normalized = JSONUtils.prettyPrint(snapshotOpt.get());
            Assertions.assertThat((String)actualJson).isEqualTo(normalized);
        }
    }
}

