/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.snapshot.internal.assertions;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.snapshot.api.UpdateMode;
import org.assertj.snapshot.internal.assertions.InternalAssertions;
import org.assertj.snapshot.internal.assertions.JavaCodeManipulator;
import org.assertj.snapshot.internal.utils.FileUtils;
import org.assertj.snapshot.internal.utils.FileUtilsImpl;
import org.assertj.snapshot.internal.utils.JSONUtils;
import org.assertj.snapshot.internal.utils.SourceCodeLocator;
import org.assertj.snapshot.internal.utils.TestCaseFinder;

class InternalInlineSnapshotCapturer {
    static final String CAPTURE_SNAPSHOT = "<capture-snapshot>";

    InternalInlineSnapshotCapturer() {
    }

    public static void assertEqual(Object actual, String expected, UpdateMode updateMode) {
        boolean shouldUpdate;
        boolean expectedDoesNotExist = expected == null || expected.equals(CAPTURE_SNAPSHOT) || expected.trim().isEmpty();
        boolean bl = shouldUpdate = expectedDoesNotExist && updateMode == UpdateMode.UPDATE_IF_NO_PREVIOUS_SNAPSHOT || updateMode == UpdateMode.UPDATE_ALWAYS;
        if (shouldUpdate) {
            InternalInlineSnapshotCapturer.captureInlineSnapshot(actual);
        } else {
            InternalAssertions.assertEqual(actual, expected);
        }
    }

    static void captureInlineSnapshot(Object actual) {
        FileUtils fileUtils = FileUtilsImpl.create();
        TestCaseFinder.AssertingTestCase testCase = TestCaseFinder.getTestCase();
        Path testCaseSourceFile = InternalInlineSnapshotCapturer.getTestCaseSourceFile(testCase);
        String testCaseSourceFileContent = fileUtils.getFileContent(testCaseSourceFile);
        String jsonToUseAsExpected = JSONUtils.prettyPrint(actual) + "\n";
        String manipulatedTestCaseContent = JavaCodeManipulator.manipulateTestCase(testCase, testCaseSourceFileContent, jsonToUseAsExpected);
        fileUtils.writeFileContent(testCaseSourceFile, manipulatedTestCaseContent);
    }

    private static Path getTestCaseSourceFile(TestCaseFinder.AssertingTestCase testCase) {
        File sourceFolderOfTestCase = SourceCodeLocator.getSourceFolder(testCase.getClassName(), testCase.getFile());
        Path testCaseSourceFile = Paths.get(sourceFolderOfTestCase.getAbsolutePath(), testCase.getFile());
        return testCaseSourceFile;
    }
}

