/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.snapshot.internal.assertions;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Position;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.TextBlockLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.List;
import java.util.Optional;
import org.assertj.snapshot.internal.utils.TestCaseFinder;

public class JavaCodeManipulator {
    public static String manipulateTestCase(TestCaseFinder.AssertingTestCase testCase, String testCaseContent, String jsonToUseAsExpected) {
        StaticJavaParser.getParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        CompilationUnit compilationUnit = StaticJavaParser.parse((String)testCaseContent);
        String classSimpleName = testCase.getClassName().substring(testCase.getClassName().lastIndexOf(".") + 1);
        Optional classOrINterfaceOpt = compilationUnit.getClassByName(classSimpleName);
        if (classOrINterfaceOpt.isEmpty()) {
            throw new IllegalStateException("Cannot find " + classSimpleName + " in " + testCaseContent);
        }
        ClassOrInterfaceDeclaration classOrINterface = (ClassOrInterfaceDeclaration)classOrINterfaceOpt.get();
        List methods = classOrINterface.getMethodsByName(testCase.getMethodName());
        if (methods.isEmpty() || methods.size() > 1) {
            throw new IllegalStateException("Cannot find " + testCase.getMethodName() + " in " + testCaseContent);
        }
        MethodDeclaration method = (MethodDeclaration)methods.get(0);
        BlockStmt methodBlock = (BlockStmt)method.getBody().get();
        for (Statement statement : methodBlock.getStatements()) {
            List methodCallExprs = statement.findAll(MethodCallExpr.class);
            for (MethodCallExpr methodCallExpr : methodCallExprs) {
                List allSimpleNameNodes = methodCallExpr.findAll(SimpleName.class);
                boolean ifMatchesInlineSnapshot = allSimpleNameNodes.stream().filter(it -> it.getId().equals("matchesInlineSnapshot") && ((Position)it.getBegin().get()).line == testCase.getLineNumber()).findFirst().isPresent();
                if (!ifMatchesInlineSnapshot) continue;
                if (methodCallExpr.getArguments().size() == 0) {
                    methodCallExpr.addArgument((Expression)new TextBlockLiteralExpr(jsonToUseAsExpected));
                } else if (methodCallExpr.getArguments().size() == 1) {
                    methodCallExpr.setArgument(0, (Expression)new TextBlockLiteralExpr(jsonToUseAsExpected));
                } else {
                    throw new IllegalStateException("Cannot find argument");
                }
                return compilationUnit.toString();
            }
        }
        throw new IllegalStateException("Unable to match assertion\n" + testCaseContent + "\n\n" + testCaseContent);
    }
}

