/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.snapshot.internal.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.logging.Logger;
import org.assertj.snapshot.internal.utils.FileUtils;

public class FileUtilsImpl
implements FileUtils {
    private static Logger LOG = Logger.getLogger(FileUtilsImpl.class.getName());
    private static FileUtils FILE_UTILS = new FileUtilsImpl();

    @SuppressFBWarnings
    public static FileUtils create() {
        return FILE_UTILS;
    }

    @SuppressFBWarnings
    public static void setFileUtils(FileUtils fileUtils) {
        LOG.info(FILE_UTILS.toString());
        FILE_UTILS = fileUtils;
    }

    @Override
    public Optional<String> findFileContent(Path path) {
        if (this.pathExists(path)) {
            try {
                return Optional.of(Files.readString(path));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    @Override
    public String getFileContent(Path path) {
        Optional<String> opt = this.findFileContent(path);
        if (opt.isPresent()) {
            return opt.get();
        }
        throw new RuntimeException(path + " not found");
    }

    @Override
    public void writeFileContent(Path sourceFile, String manipulatedSourceFileContent) {
        try {
            Files.writeString(sourceFile, (CharSequence)manipulatedSourceFileContent, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(sourceFile.toString(), e);
        }
    }

    @Override
    public void createDirs(Path path) {
        if (!this.pathExists(path)) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean pathExists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }
}

