/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.snapshot.internal.utils;

import com.fasterxml.jackson.databind.ObjectMapper;

public class JSONUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String prettyPrint(String jsonString) {
        Object deserialized = JSONUtils.readValue(jsonString, Object.class);
        return JSONUtils.writeValueAsString(deserialized);
    }

    public static String prettyPrint(Object object) {
        return JSONUtils.writeValueAsString(object);
    }

    private static String writeValueAsString(Object object) {
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("From: " + object, e);
        }
    }

    private static Object readValue(String jsonString, Class<?> clazz) {
        try {
            return OBJECT_MAPPER.readValue(jsonString, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(jsonString, e);
        }
    }
}

