/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.snapshot.internal.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class SourceCodeLocator {
    public static File getSourceFolder(String className, String fileName) {
        Path findInFolder;
        String sourceCodePackageFolder = SourceCodeLocator.getPackageFolder(className);
        List<Path> matchingFiles = SourceCodeLocator.getMatchingFiles(fileName, sourceCodePackageFolder, findInFolder = Paths.get("src", new String[0]).toAbsolutePath());
        if (matchingFiles == null || matchingFiles.size() == 0) {
            throw new RuntimeException("Cannot find " + className + " in " + findInFolder.toAbsolutePath());
        }
        if (matchingFiles.size() > 1) {
            throw new RuntimeException("Cannot find " + className + " in " + findInFolder.toAbsolutePath() + ". Found multiple matches: " + matchingFiles);
        }
        return matchingFiles.get(0).toFile().getParentFile();
    }

    private static List<Path> getMatchingFiles(String fileName, String sourceCodePackageFolder, Path findInFolder) {
        try {
            return Files.find(findInFolder, Integer.MAX_VALUE, SourceCodeLocator.matches(fileName, sourceCodePackageFolder), new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BiPredicate<Path, BasicFileAttributes> matches(String fileName, String sourceCodePackageFolder) {
        return (file, attr) -> {
            String dir = file.getParent().toFile().getAbsolutePath();
            String name = file.toFile().getName();
            return dir.endsWith(sourceCodePackageFolder) && name.equals(fileName);
        };
    }

    private static String getPackageFolder(String className) {
        String[] packageAndClassName = className.split("\\.");
        return Arrays.asList(packageAndClassName).subList(0, packageAndClassName.length - 1).stream().collect(Collectors.joining("/"));
    }
}

