/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.snapshot.internal.utils;

public class TestCaseFinder {
    public static AssertingTestCase getTestCase() {
        StackTraceElement[] stackTrace;
        Exception exception = new Exception();
        for (StackTraceElement element : stackTrace = exception.getStackTrace()) {
            String file = element.getFileName();
            String methodName = element.getMethodName();
            String className = element.getClassName();
            int lineNumber = element.getLineNumber();
            if (className.startsWith("org.assertj")) continue;
            return new AssertingTestCase(className, file, methodName, lineNumber);
        }
        throw new RuntimeException("Cannot find test case");
    }

    public static class AssertingTestCase {
        private final String className;
        private final String file;
        private final String methodName;
        private final int lineNumber;

        AssertingTestCase(String className, String file, String methodName, int lineNumber) {
            this.className = className;
            this.file = file;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFile() {
            return this.file;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String toString() {
            return "AssertingTestCase [className=" + this.className + ", file=" + this.file + ", methodName=" + this.methodName + ", lineNumber=" + this.lineNumber + "]";
        }
    }
}

