/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.plugin.gradle;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.Project;
import se.bjurr.gitchangelog.api.GitChangelogApi;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersion;
import se.bjurr.gitchangelog.plugin.gradle.SetSemanticVersionParameters;
import se.bjurr.gitchangelog.plugin.gradle.SortedProperties;

public class SetSemanticVersion {
    public static void setVersion(SetSemanticVersionParameters params) {
        block20: {
            try {
                GitChangelogApi gitChangelogApiBuilder = GitChangelogApi.gitChangelogApiBuilder();
                gitChangelogApiBuilder.withFromRepo(params.project.getRootDir());
                if (SetSemanticVersion.isSupplied(params.majorVersionPattern)) {
                    gitChangelogApiBuilder.withSemanticMajorVersionPattern(params.majorVersionPattern);
                }
                if (SetSemanticVersion.isSupplied(params.minorVersionPattern)) {
                    gitChangelogApiBuilder.withSemanticMinorVersionPattern(params.minorVersionPattern);
                }
                if (SetSemanticVersion.isSupplied(params.patchVersionPattern)) {
                    gitChangelogApiBuilder.withSemanticPatchVersionPattern(params.patchVersionPattern);
                }
                if (SetSemanticVersion.isSupplied(params.ignoreTagsIfNameMatches)) {
                    gitChangelogApiBuilder.withIgnoreTagsIfNameMatches(params.ignoreTagsIfNameMatches);
                }
                SemanticVersion nextSemanticVersion = gitChangelogApiBuilder.getCurrentSemanticVersion();
                boolean notTagged = nextSemanticVersion.findTag().isEmpty();
                boolean suffixWithSnapshot = SetSemanticVersion.isSuppliedAndTrue(params.suffixSnapshot) || SetSemanticVersion.isSuppliedAndTrue(params.suffixSnapshotIfNotTagged) && notTagged;
                Object nextVersion = suffixWithSnapshot ? nextSemanticVersion.getVersion() + "-SNAPSHOT" : nextSemanticVersion.getVersion();
                File propertyFile = params.project.getRootProject().file((Object)"gradle.properties");
                SortedProperties gradleProps = new SortedProperties();
                try (InputStream is = Files.newInputStream(propertyFile.toPath(), new OpenOption[0]);){
                    gradleProps.load(is);
                }
                String currentVersion = gradleProps.getProperty("version");
                if (((String)nextVersion).equals(currentVersion)) {
                    params.project.getLogger().info("Leaving semantic version " + currentVersion + " unchanged.");
                    break block20;
                }
                params.project.getLogger().lifecycle("Setting semantic version to " + (String)nextVersion + " (was " + currentVersion + "). Storing in " + String.valueOf(propertyFile));
                gradleProps.setProperty("version", (String)nextVersion);
                try (OutputStream os = Files.newOutputStream(propertyFile.toPath(), new OpenOption[0]);){
                    gradleProps.store(os, "");
                }
                params.project.setVersion(nextVersion);
                params.project.getAllprojects().forEach(arg_0 -> SetSemanticVersion.lambda$setVersion$0((String)nextVersion, arg_0));
            }
            catch (Exception e) {
                params.project.getLogger().error("GitChangelogVersion", (Throwable)e);
            }
        }
    }

    public static boolean isSuppliedAndTrue(Boolean param) {
        return param != null && param != false;
    }

    public static boolean isSupplied(String param) {
        return param != null && !param.isEmpty();
    }

    private static /* synthetic */ void lambda$setVersion$0(String nextVersion, Project p) {
        p.setVersion((Object)nextVersion);
    }
}

