/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.helper.EachHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.Tag;
import se.bjurr.gitchangelog.internal.model.Transformer;

public class Helpers {
    private static final Pattern CONVENTIONAL_PATTERN = Pattern.compile("^(\\w+)(\\(([\\w:]+)\\)?)?(\\!?):(.+)");
    private static final Pattern FOOTER_PATTERN = Pattern.compile("^(BREAKING[ -]CHANGE|[^ ]+)(((: )|( #))(.+))");
    public static final Map<String, Helper<?>> ALL = new TreeMap();

    private static Object each(Options options, List<?> elements) throws IOException {
        return new EachHelper().apply(elements, options);
    }

    private static Options.Buffer conditional(Options options, boolean condition) throws IOException {
        Options.Buffer buffer = options.buffer();
        if (condition) {
            buffer.append(options.fn());
        } else {
            buffer.append(options.inverse());
        }
        return buffer;
    }

    private static String getDate(String tagTime) {
        if (tagTime == null || !tagTime.contains(" ")) {
            return "";
        }
        return tagTime.split(" ")[0];
    }

    private static boolean commitScope(Commit commit, Options options) {
        String scope = options.hash("scope").toString();
        return Helpers.commitScopes(commit.getMessage()).stream().filter(it -> it.matches(scope)).findFirst().isPresent();
    }

    private static String revertedCommit(Object commitMessage) {
        Matcher matcher = Transformer.PATTERN_THIS_REVERTS.matcher(commitMessage.toString());
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private static List<String> commitFixes(Object commitMessage) {
        Matcher matcher = Pattern.compile("\\(fixes ([^)]+)").matcher(commitMessage.toString());
        if (!matcher.find()) {
            return new ArrayList<String>();
        }
        String group = matcher.group(1);
        String value = group == null ? "" : group;
        return Arrays.stream(value.split(" ")).map(it -> it.trim()).collect(Collectors.toList());
    }

    private static List<String> commitRefs(Object commitMessage) {
        Matcher matcher = Pattern.compile("\\(refs ([^)]+)").matcher(commitMessage.toString());
        if (!matcher.find()) {
            return new ArrayList<String>();
        }
        String group = matcher.group(1);
        String value = group == null ? "" : group;
        return Arrays.stream(value.split(" ")).map(it -> it.trim()).collect(Collectors.toList());
    }

    private static String commitDescription(Object commitMessage) {
        String value;
        Matcher matcher = CONVENTIONAL_PATTERN.matcher(commitMessage.toString());
        if (!matcher.find()) {
            return "";
        }
        String group = matcher.group(5);
        String string = value = group == null ? "" : group;
        if (value.indexOf("(refs ") != -1) {
            value = value.substring(0, value.indexOf("(refs "));
        }
        if (value.indexOf("(fixes ") != -1) {
            value = value.substring(0, value.indexOf("(fixes "));
        }
        return value.trim();
    }

    private static List<String> commitScopes(Object commitMessage) {
        Matcher matcher = CONVENTIONAL_PATTERN.matcher(commitMessage.toString());
        if (!matcher.find()) {
            return new ArrayList<String>();
        }
        String group = matcher.group(3);
        if (group == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(group.split(":")).map(it -> it.trim()).collect(Collectors.toList());
    }

    private static boolean commitBreaking(String commitMessage) {
        String value;
        String type = Helpers.getType(commitMessage);
        if (type.matches("[Bb]reaking")) {
            return true;
        }
        Matcher matcher = CONVENTIONAL_PATTERN.matcher(commitMessage.toString());
        if (!matcher.find()) {
            return false;
        }
        String group = matcher.group(4);
        String string = value = group == null ? "" : group;
        if (value.equals("!")) {
            return true;
        }
        for (Footer footer : Helpers.getMessageParts((String)commitMessage).footers) {
            if (!footer.token.equals("BREAKING CHANGE") && !footer.token.equals("BREAKING-CHANGE")) continue;
            return true;
        }
        return false;
    }

    private static boolean containsBreaking(List<Commit> commits, Options options) {
        for (Commit commit : commits) {
            if (!Helpers.commitBreaking(commit.getMessage())) continue;
            return true;
        }
        return false;
    }

    private static boolean containsType(List<Commit> commits, Options options) {
        for (Commit commit : commits) {
            if (!Helpers.commitType(commit.getMessage(), options)) continue;
            return true;
        }
        return false;
    }

    private static boolean commitType(String commitMessage, Options options) {
        String type = options.hash("type").toString();
        return Helpers.getType(commitMessage).matches(type);
    }

    private static String getType(String commitMessage) {
        Matcher matcher = CONVENTIONAL_PATTERN.matcher(commitMessage.toString());
        if (!matcher.find()) {
            boolean matchesRevert = Transformer.PATTERN_THIS_REVERTS.matcher(commitMessage).find();
            if (matchesRevert) {
                return "revert";
            }
            return "";
        }
        String group = matcher.group(1);
        return group == null ? "" : group.trim();
    }

    private static boolean isReleaseTag(Tag tag) {
        return Pattern.matches("^[0-9]+\\.[0-9]+\\.[0-9]+", tag.getName().replaceAll("[^0-9\\.]", ""));
    }

    private static MessageParts getMessageParts(String commitMessage) {
        MessageParts mp = new MessageParts();
        List<String> lines = Arrays.asList(commitMessage.trim().split("\\r?\\n"));
        boolean paragraphs = true;
        Footer currentFooter = null;
        String currentParagraph = null;
        for (int i = 1; i < lines.size(); ++i) {
            boolean shouldSaveState;
            boolean isFooter;
            String line = lines.get(i);
            boolean empty = line.trim().isEmpty();
            Footer footerCandidate = Helpers.toFooter(line);
            boolean bl = isFooter = footerCandidate != null;
            if (isFooter && currentFooter == null) {
                paragraphs = false;
                currentFooter = footerCandidate;
            } else if (currentFooter != null) {
                currentFooter.value = currentFooter.value + "\n" + line;
            }
            if (paragraphs && !empty && paragraphs) {
                currentParagraph = currentParagraph == null ? line : currentParagraph + "\n" + line;
            }
            boolean isLastLine = i == lines.size() - 1;
            boolean isNextLineEmpty = !isLastLine && lines.get(i + 1).trim().isEmpty();
            boolean isNextLineNewFooter = !isLastLine && Helpers.toFooter(lines.get(i + 1)) != null;
            boolean bl2 = shouldSaveState = isLastLine || isNextLineEmpty || isNextLineNewFooter;
            if (!shouldSaveState) continue;
            if (currentFooter != null) {
                mp.footers.add(currentFooter);
                currentFooter = null;
            }
            if (currentParagraph == null) continue;
            mp.paragraphs.add(currentParagraph);
            currentParagraph = null;
        }
        return mp;
    }

    private static Footer toFooter(String from) {
        Matcher m = FOOTER_PATTERN.matcher(from);
        Footer f = new Footer();
        if (m.find()) {
            f.token = m.group(1);
            f.value = m.group(6);
            return f;
        }
        return null;
    }

    static {
        ALL.put("ifEquals", (a, options) -> {
            Object b = options.params[0];
            boolean equality = a.equals(b);
            return Helpers.conditional(options, equality);
        });
        ALL.put("ifMatches", (a, options) -> {
            String regexp = (String)options.params[0];
            boolean equality = a.toString().matches(regexp);
            return Helpers.conditional(options, equality);
        });
        ALL.put("subString", (a, options) -> {
            Integer from = (Integer)options.params[0];
            if (options.params.length == 1) {
                return a.toString().substring(from);
            }
            Integer to = (Integer)options.params[1];
            return a.toString().substring(from, to);
        });
        ALL.put("ifReleaseTag", (tag, options) -> Helpers.conditional(options, Helpers.isReleaseTag(tag)));
        ALL.put("tagDate", (tag, options) -> Helpers.getDate(tag.getTagTime()));
        ALL.put("commitDate", (commit, options) -> Helpers.getDate(commit.getCommitTime()));
        ALL.put("ifContainsType", (commits, options) -> Helpers.conditional(options, Helpers.containsType(commits, options)));
        ALL.put("ifContainsBreaking", (commits, options) -> Helpers.conditional(options, Helpers.containsBreaking(commits, options)));
        ALL.put("ifCommitType", (commit, options) -> Helpers.conditional(options, Helpers.commitType(commit.getMessage(), options)));
        ALL.put("ifCommitBreaking", (commit, options) -> Helpers.conditional(options, Helpers.commitBreaking(commit.getMessage())));
        ALL.put("ifCommitScope", (commit, options) -> Helpers.conditional(options, Helpers.commitScope(commit, options)));
        ALL.put("ifCommitHasFooters", (commit, options) -> Helpers.conditional(options, Helpers.getMessageParts((String)commit.getMessage()).footers.size() > 0));
        ALL.put("ifCommitHasParagraphs", (commit, options) -> Helpers.conditional(options, Helpers.getMessageParts((String)commit.getMessage()).paragraphs.size() > 0));
        ALL.put("eachCommitScope", (commit, options) -> Helpers.each(options, Helpers.commitScopes(commit.getMessage())));
        ALL.put("commitDescription", (commit, options) -> Helpers.commitDescription(commit.getMessage()));
        ALL.put("eachCommitRefs", (commit, options) -> Helpers.each(options, Helpers.commitRefs(commit.getMessage())));
        ALL.put("eachCommitFixes", (commit, options) -> Helpers.each(options, Helpers.commitFixes(commit.getMessage())));
        ALL.put("revertedCommit", (commit, options) -> Helpers.revertedCommit(commit.getMessage()));
        ALL.put("eachCommitParagraph", (commit, options) -> Helpers.each(options, Helpers.getMessageParts((String)commit.getMessage()).paragraphs));
        ALL.put("eachCommitFooter", (commit, options) -> Helpers.each(options, Helpers.getMessageParts((String)commit.getMessage()).footers));
        ALL.put("ifFooterHasValue", (footer, options) -> Helpers.conditional(options, !footer.value.trim().isEmpty()));
    }

    static class Footer {
        String token = "";
        String value = "";

        Footer() {
        }

        public String getToken() {
            return this.token;
        }

        public String getValue() {
            return this.value;
        }
    }

    static class MessageParts {
        List<String> paragraphs = new ArrayList<String>();
        List<Footer> footers = new ArrayList<Footer>();

        MessageParts() {
        }

        public List<Footer> getFooters() {
            return this.footers;
        }

        public List<String> getParagraphs() {
            return this.paragraphs;
        }
    }
}

