/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import java.io.Serializable;
import java.util.List;
import se.bjurr.gitchangelog.api.model.Issue;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class IssueType
implements Serializable {
    private static final long serialVersionUID = 8850522973130773606L;
    private final String name;
    private final List<Issue> issues;
    private final SettingsIssueType type;

    public IssueType(List<Issue> issues, String name) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.issues = Preconditions.checkNotNull(issues, "issues");
        Preconditions.checkState(!issues.isEmpty(), "Issues empty!");
        this.type = issues.get(0).getIssueType();
    }

    public SettingsIssueType getType() {
        return this.type;
    }

    public boolean isJira() {
        return this.type == SettingsIssueType.JIRA;
    }

    public boolean isGitHub() {
        return this.type == SettingsIssueType.GITHUB;
    }

    public boolean isGitLab() {
        return this.type == SettingsIssueType.GITLAB;
    }

    public boolean isCustom() {
        return this.type == SettingsIssueType.CUSTOM;
    }

    public boolean isNoIssue() {
        return this.type == SettingsIssueType.NOISSUE;
    }

    public String getName() {
        return this.name;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public String toString() {
        return "IssueType: " + this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.issues == null ? 0 : this.issues.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IssueType other = (IssueType)obj;
        if (this.issues == null ? other.issues != null : !this.issues.equals(other.issues)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }
}

