/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.jira;

import java.util.Map;
import java.util.Optional;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraClient;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraIssue;
import se.bjurr.gitchangelog.internal.integrations.rest.RestClient;

public class DefaultJiraClient
extends JiraClient {
    private RestClient client = new RestClient();

    public DefaultJiraClient(String api) {
        super(api);
    }

    @Override
    public JiraClient withBasicCredentials(String username, String password) {
        this.client = this.client.withBasicAuthCredentials(username, password);
        return this;
    }

    @Override
    public JiraClient withTokenCredentials(String token) {
        this.client = this.client.withTokenAuthCredentials(token);
        return this;
    }

    @Override
    public JiraClient withHeaders(Map<String, String> headers) {
        this.client = this.client.withHeaders(headers);
        return this;
    }

    @Override
    public Optional<JiraIssue> getIssue(String issue) throws GitChangelogIntegrationException {
        String endpoint = this.getEndpoint(issue);
        Optional<String> json = this.client.get(endpoint);
        if (json.isPresent()) {
            JiraIssue jiraIssue = this.toJiraIssue(issue, json.get());
            return Optional.of(jiraIssue);
        }
        return Optional.empty();
    }
}

