/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.semantic;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersion;

public class SemanticVersioning {
    private final List<String> commits;
    private final Pattern majorPattern;
    private final Pattern minorPattern;
    private final List<String> tags;

    public SemanticVersioning(List<String> tags, List<String> commits, String majorPattern, String minorPattern) {
        this.tags = tags;
        this.commits = commits;
        this.majorPattern = Pattern.compile(this.notNull(majorPattern, "majorPattern"));
        this.minorPattern = Pattern.compile(this.notNull(minorPattern, "minorPattern"));
    }

    public SemanticVersion getNextVersion() {
        SemanticVersion highestVersion = SemanticVersioning.getHighestVersion(this.tags);
        VERSION_STEP versionStep = this.getVersionStep();
        if (versionStep == VERSION_STEP.MAJOR) {
            return new SemanticVersion(highestVersion.getMajor() + 1, 0, 0);
        }
        if (versionStep == VERSION_STEP.MINOR) {
            return new SemanticVersion(highestVersion.getMajor(), highestVersion.getMinor() + 1, 0);
        }
        return new SemanticVersion(highestVersion.getMajor(), highestVersion.getMinor(), highestVersion.getPatch() + 1);
    }

    public static SemanticVersion getHighestVersion(List<String> tags) {
        SemanticVersion highest = new SemanticVersion(0, 0, 0);
        for (String tag : tags) {
            Matcher semanticVersionMatcher = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+").matcher(tag.replaceAll("[^0-9\\.]", ""));
            if (!semanticVersionMatcher.find()) continue;
            String[] dotParts = semanticVersionMatcher.group().split("\\.");
            SemanticVersion candidate = new SemanticVersion(new Integer(dotParts[0]), new Integer(dotParts[1]), new Integer(dotParts[2]));
            candidate.setTag(tag);
            if (candidate.getMajor() > highest.getMajor()) {
                highest = candidate;
                continue;
            }
            if (candidate.getMajor() == highest.getMajor() && candidate.getMinor() > highest.getMinor()) {
                highest = candidate;
                continue;
            }
            if (candidate.getMajor() != highest.getMajor() || candidate.getMinor() != highest.getMinor() || candidate.getPatch() <= highest.getPatch()) continue;
            highest = candidate;
        }
        return highest;
    }

    private VERSION_STEP getVersionStep() {
        VERSION_STEP versionStep = VERSION_STEP.PATCH;
        for (String commit : this.commits) {
            if (this.majorPattern.matcher(commit).find()) {
                return VERSION_STEP.MAJOR;
            }
            if (!this.minorPattern.matcher(commit).find()) continue;
            versionStep = VERSION_STEP.MINOR;
        }
        return versionStep;
    }

    private String notNull(String value, String msg) {
        if (value == null) {
            throw new RuntimeException(msg + " is not defined");
        }
        return value;
    }

    public static enum VERSION_STEP {
        MAJOR,
        MINOR,
        PATCH;

    }
}

