/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogRepositoryException;
import se.bjurr.gitchangelog.api.helpers.Helpers;
import se.bjurr.gitchangelog.api.model.Changelog;
import se.bjurr.gitchangelog.internal.git.GitRepo;
import se.bjurr.gitchangelog.internal.git.GitRepoData;
import se.bjurr.gitchangelog.internal.git.GitRepoDataHelper;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.issues.IssueParser;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.model.Transformer;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersion;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersioning;
import se.bjurr.gitchangelog.internal.settings.Settings;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;
import se.bjurr.gitchangelog.internal.util.ResourceLoader;

public class GitChangelogApi {
    private Settings settings;
    private String templateContent;
    private Handlebars handlebars;
    private final AtomicInteger helperCounter = new AtomicInteger();

    public static GitChangelogApi gitChangelogApiBuilder() {
        return new GitChangelogApi();
    }

    private GitChangelogApi() {
        this.settings = new Settings();
        this.handlebars = new Handlebars();
        this.handlebars.setPrettyPrint(true);
        for (Map.Entry<String, Helper<?>> helper : Helpers.ALL.entrySet()) {
            this.handlebars.registerHelper(helper.getKey(), helper.getValue());
        }
    }

    private GitChangelogApi(Settings settings) {
        this.settings = settings;
    }

    public Changelog getChangelog() throws GitChangelogRepositoryException {
        return this.getChangelog(true);
    }

    private Changelog getChangelog(boolean shouldUseIntegrationIfConfigured) throws GitChangelogRepositoryException {
        Changelog changelog;
        GitRepo gitRepo = new GitRepo(new File(this.settings.getFromRepo()));
        try {
            changelog = this.getChangelog(gitRepo, shouldUseIntegrationIfConfigured);
        }
        catch (Throwable throwable) {
            try {
                try {
                    gitRepo.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GitChangelogRepositoryException("", e);
            }
        }
        gitRepo.close();
        return changelog;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void render(Writer writer) throws GitChangelogRepositoryException {
        Template template = null;
        String templateString = this.getTemplateString();
        try {
            template = this.handlebars.compileInline(templateString);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot render:\n\n" + templateString, e);
        }
        try {
            Changelog changelog = this.getChangelog(GitChangelogApi.shouldUseIntegrationIfConfigured(templateString));
            Map<String, Object> extendedVariables = this.settings.getExtendedVariables();
            if (extendedVariables == null) {
                throw new IllegalStateException("extendedVariables cannot be null");
            }
            Context changelogContext = Context.newContext((Object)changelog).combine(extendedVariables);
            template.apply(changelogContext, writer);
        }
        catch (IOException e) {
            throw new GitChangelogRepositoryException("", e);
        }
    }

    public String getTemplateString() {
        if (this.templateContent != null) {
            return this.templateContent;
        }
        String resourceName = this.settings.getTemplatePath();
        return ResourceLoader.getResourceOrFile(resourceName);
    }

    static boolean shouldUseIntegrationIfConfigured(String templateContent) {
        return templateContent.contains("{{type}}") || templateContent.contains("{{link}}") || templateContent.contains("{{title}}") || templateContent.replaceAll("\\r?\\n", " ").matches(".*\\{\\{#?labels\\}\\}.*");
    }

    public String render() throws GitChangelogRepositoryException {
        StringWriter writer = new StringWriter();
        this.render(writer);
        return ((Object)writer).toString();
    }

    public void toFile(File file) throws GitChangelogRepositoryException, IOException {
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            boolean folderExists;
            boolean bl = folderExists = parentFile.exists() || parentFile.mkdirs();
            if (!folderExists) {
                throw new RuntimeException("Folder " + parentFile.getAbsolutePath() + " cannot be created");
            }
        }
        Files.write(file.toPath(), this.render().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void prependToFile(File file) throws GitChangelogRepositoryException, IOException {
        if (!file.exists()) {
            this.toFile(file);
            return;
        }
        String prepend = this.render();
        String changelogContent = new String(Files.readAllBytes(file.toPath()));
        Files.write(file.toPath(), (prepend + "\n" + changelogContent).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public SemanticVersion getNextSemanticVersion() throws GitChangelogRepositoryException {
        Optional<String> tag;
        boolean fromGiven = this.settings.getFromRef().isPresent() || this.settings.getFromCommit().isPresent();
        SemanticVersion highestSemanticVersion = this.getHighestSemanticVersion();
        if (!fromGiven && (tag = highestSemanticVersion.findTag()).isPresent()) {
            this.withFromRef(tag.get());
        }
        Changelog changelog = this.getChangelog(false);
        List<String> tags = this.getTagsAsStrings(changelog);
        List<String> commits = this.getCommitMessages(changelog);
        String majorVersionPattern = this.settings.getSemanticMajorPattern().orElse(null);
        String minorVersionPattern = this.settings.getSemanticMinorPattern();
        String patchVersionPattern = this.settings.getSemanticPatchPattern();
        SemanticVersioning semanticVersioning = new SemanticVersioning(tags, commits, majorVersionPattern, minorVersionPattern, patchVersionPattern);
        return semanticVersioning.getNextVersion(highestSemanticVersion);
    }

    public SemanticVersion getHighestSemanticVersion() throws GitChangelogRepositoryException {
        Changelog changelog = this.getChangelog(false);
        List<String> tags = this.getTagsAsStrings(changelog);
        return SemanticVersioning.getHighestVersion(tags);
    }

    private List<String> getCommitMessages(Changelog changelog) {
        return changelog.getCommits().stream().map(it -> it.getMessage()).collect(Collectors.toList());
    }

    private List<String> getTagsAsStrings(Changelog changelog) {
        return changelog.getTags().stream().map(it -> it.getName()).collect(Collectors.toList());
    }

    public GitChangelogApi withSemanticMajorVersionPattern(String major) throws GitChangelogRepositoryException {
        this.settings.setSemanticMajorPattern(major);
        return this;
    }

    public GitChangelogApi withSemanticMinorVersionPattern(String minor) throws GitChangelogRepositoryException {
        this.settings.setSemanticMinorPattern(minor);
        return this;
    }

    public GitChangelogApi withSemanticPatchVersionPattern(String patch) throws GitChangelogRepositoryException {
        this.settings.setSemanticPatchPattern(patch);
        return this;
    }

    public GitChangelogApi withHandlebarsHelper(String javascriptHelper) throws GitChangelogRepositoryException, IOException {
        int helperIndex = this.helperCounter.getAndIncrement();
        this.handlebars.registerHelpers("helper-" + helperIndex, javascriptHelper);
        return this;
    }

    public GitChangelogApi withHandlebarsHelper(String name, Helper<?> helper) throws GitChangelogRepositoryException, IOException {
        this.handlebars.registerHelper(name, helper);
        return this;
    }

    public GitChangelogApi withCustomIssue(String name, String pattern, String link, String title) {
        this.settings.addCustomIssue(new SettingsIssue(name, pattern, link, title));
        return this;
    }

    public GitChangelogApi withDateFormat(String dateFormat) {
        this.settings.setDateFormat(dateFormat);
        return this;
    }

    public GitChangelogApi withExtendedVariables(Map<String, Object> extendedVariables) {
        this.settings.setExtendedVariables(extendedVariables);
        return this;
    }

    public GitChangelogApi withExtendedHeaders(Map<String, String> extendedHeaders) {
        this.settings.setExtendedRestHeaders(extendedHeaders);
        return this;
    }

    public GitChangelogApi withFromCommit(String fromCommit) {
        this.settings.setFromCommit(fromCommit);
        return this;
    }

    public GitChangelogApi withFromRef(String fromBranch) {
        this.settings.setFromRef(fromBranch);
        return this;
    }

    public GitChangelogApi withFromRepo(String fromRepo) {
        this.settings.setFromRepo(fromRepo);
        return this;
    }

    public GitChangelogApi withFromRepo(File fromRepo) {
        this.settings.setFromRepo(fromRepo.getAbsolutePath());
        return this;
    }

    public GitChangelogApi withGitHubApi(String gitHubApi) {
        this.settings.setGitHubApi(gitHubApi);
        return this;
    }

    public GitChangelogApi withGitHubIssuePattern(String gitHubIssuePattern) {
        this.settings.setGitHubIssuePattern(gitHubIssuePattern);
        return this;
    }

    public GitChangelogApi withGitHubToken(String gitHubToken) {
        this.settings.setGitHubToken(gitHubToken);
        return this;
    }

    public GitChangelogApi withGitLabIssuePattern(String gitLabIssuePattern) {
        this.settings.setGitLabIssuePattern(gitLabIssuePattern);
        return this;
    }

    public GitChangelogApi withGitLabProjectName(String gitLabProjectName) {
        this.settings.setGitLabProjectName(gitLabProjectName);
        return this;
    }

    public GitChangelogApi withGitLabServer(String gitLabServer) {
        this.settings.setGitLabServer(gitLabServer);
        return this;
    }

    public GitChangelogApi withGitLabToken(String gitLabToken) {
        this.settings.setGitLabToken(gitLabToken);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsWithMessage(String ignoreCommitsIfMessageMatches) {
        this.settings.setIgnoreCommitsIfMessageMatches(ignoreCommitsIfMessageMatches);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsOlderThan(Date ignoreCommitsIfOlderThan) {
        this.settings.setIgnoreCommitsIfOlderThan(ignoreCommitsIfOlderThan);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsWithoutIssue(boolean ignoreCommitsWithoutIssue) {
        this.settings.setIgnoreCommitsWithoutIssue(ignoreCommitsWithoutIssue);
        return this;
    }

    public GitChangelogApi withIgnoreTagsIfNameMatches(String ignoreTagsIfNameMatches) {
        this.settings.setIgnoreTagsIfNameMatches(ignoreTagsIfNameMatches);
        return this;
    }

    public GitChangelogApi withJiraIssuePattern(String jiraIssuePattern) {
        this.settings.setJiraIssuePattern(jiraIssuePattern);
        return this;
    }

    public GitChangelogApi withJiraPassword(String string) {
        this.settings.setJiraPassword(string);
        return this;
    }

    public GitChangelogApi withJiraBasicAuthString(String string) {
        this.settings.setJiraToken(string);
        return this;
    }

    public GitChangelogApi withJiraServer(String jiraServer) {
        this.settings.setJiraServer(jiraServer);
        return this;
    }

    public GitChangelogApi withJiraUsername(String string) {
        this.settings.setJiraUsername(string);
        return this;
    }

    public GitChangelogApi withRedmineIssuePattern(String redmineIssuePattern) {
        this.settings.setRedmineIssuePattern(redmineIssuePattern);
        return this;
    }

    public GitChangelogApi withRedminePassword(String string) {
        this.settings.setRedminePassword(string);
        return this;
    }

    public GitChangelogApi withRedmineToken(String string) {
        this.settings.setRedmineToken(string);
        return this;
    }

    public GitChangelogApi withRedmineServer(String redmineServer) {
        this.settings.setRedmineServer(redmineServer);
        return this;
    }

    public GitChangelogApi withRedmineUsername(String string) {
        this.settings.setRedmineUsername(string);
        return this;
    }

    public GitChangelogApi withNoIssueName(String noIssueName) {
        this.settings.setNoIssueName(noIssueName);
        return this;
    }

    public GitChangelogApi withReadableTagName(String readableTagName) {
        this.settings.setReadableTagName(readableTagName);
        return this;
    }

    public GitChangelogApi withRemoveIssueFromMessageArgument(boolean removeIssueFromMessage) {
        this.settings.setRemoveIssueFromMessage(removeIssueFromMessage);
        return this;
    }

    public GitChangelogApi withSettings(URL url) {
        this.settings = Settings.fromFile(url);
        return this;
    }

    public GitChangelogApi withTemplateContent(String templateContent) {
        this.templateContent = templateContent;
        return this;
    }

    public GitChangelogApi withTemplatePath(String templatePath) {
        this.settings.setTemplatePath(templatePath);
        return this;
    }

    public GitChangelogApi withTimeZone(String timeZone) {
        this.settings.setTimeZone(timeZone);
        return this;
    }

    public GitChangelogApi withToCommit(String toCommit) {
        this.settings.setToCommit(toCommit);
        return this;
    }

    public GitChangelogApi withToRef(String toBranch) {
        this.settings.setToRef(toBranch);
        return this;
    }

    public GitChangelogApi withPathFilter(String pathFilter) {
        this.settings.setPathFilter(pathFilter);
        return this;
    }

    public GitChangelogApi withUntaggedName(String untaggedName) {
        this.settings.setUntaggedName(untaggedName);
        return this;
    }

    private Changelog getChangelog(GitRepo gitRepo, boolean shouldUseIntegrationIfConfigured) throws GitChangelogRepositoryException {
        gitRepo.setTreeFilter(this.settings.getSubDirFilter());
        ObjectId fromId = this.getId(gitRepo, this.settings.getFromRef(), this.settings.getFromCommit()).orElse(gitRepo.getCommit("0000000000000000000000000000000000000000"));
        Optional<ObjectId> toIdOpt = this.getId(gitRepo, this.settings.getToRef(), this.settings.getToCommit());
        ObjectId toId = toIdOpt.isPresent() ? toIdOpt.get() : gitRepo.getRef("master");
        GitRepoData gitRepoData = gitRepo.getGitRepoData(fromId, toId, this.settings.getUntaggedName(), this.settings.getIgnoreTagsIfNameMatches());
        if (!this.settings.getGitHubApi().isPresent()) {
            this.settings.setGitHubApi(gitRepoData.findGitHubApi().orElse(null));
        }
        if (!this.settings.getGitLabServer().isPresent()) {
            this.settings.setGitLabServer(gitRepoData.findGitLabServer().orElse(null));
            this.settings.setGitLabProjectName(gitRepoData.findOwnerName().orElse(null));
        }
        List<GitCommit> diff = gitRepoData.getGitCommits();
        List<ParsedIssue> issues = new IssueParser(this.settings, diff).parseForIssues(shouldUseIntegrationIfConfigured);
        if (this.settings.ignoreCommitsWithoutIssue()) {
            gitRepoData = GitRepoDataHelper.removeCommitsWithoutIssue(issues, gitRepoData);
            diff = gitRepoData.getGitCommits();
        }
        List<GitTag> tags = gitRepoData.getGitTags();
        Transformer transformer = new Transformer(this.settings);
        return new Changelog(transformer.toCommits(diff), transformer.toTags(tags, issues), transformer.toAuthors(diff), transformer.toIssues(issues), transformer.toIssueTypes(issues), gitRepoData.findOwnerName().orElse(null), gitRepoData.findRepoName().orElse(null));
    }

    private Optional<ObjectId> getId(GitRepo gitRepo, Optional<String> ref, Optional<String> commit) throws GitChangelogRepositoryException {
        if (ref.isPresent()) {
            return Optional.of(gitRepo.getRef(ref.get()));
        }
        if (commit.isPresent()) {
            return Optional.of(gitRepo.getCommit(commit.get()));
        }
        return Optional.empty();
    }
}

