/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.rest;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;

public class RestClient {
    private static Logger logger = LoggerFactory.getLogger(RestClient.class);
    private static RestClient mockedRestClient;
    private final Map<String, Optional<String>> urlCache = new ConcurrentHashMap<String, Optional<String>>();
    private String basicAuthString;
    private Map<String, String> headers;

    public RestClient withBasicAuthCredentials(String username, String password) {
        try {
            this.basicAuthString = Base64.getEncoder().encodeToString((username + ":" + password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public RestClient withTokenAuthCredentials(String token) {
        this.basicAuthString = token;
        return this;
    }

    public RestClient withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Optional<String> get(String url) throws GitChangelogIntegrationException {
        try {
            if (!this.urlCache.containsKey(url)) {
                Optional<String> content = this.doGet(url);
                this.urlCache.put(url, content);
            }
            return this.urlCache.get(url);
        }
        catch (Exception e) {
            throw new GitChangelogIntegrationException("Problems invoking " + url, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> doGet(String urlParam) {
        String response = null;
        HttpURLConnection conn = null;
        try {
            logger.info("GET:\n" + urlParam);
            URL url = new URL(urlParam);
            conn = this.openConnection(url);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            if (this.headers != null) {
                for (Map.Entry entry : this.headers.entrySet()) {
                    conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (this.basicAuthString != null) {
                conn.setRequestProperty("Authorization", "Basic " + this.basicAuthString);
            }
            Optional<String> optional = Optional.of(this.getResponse(conn));
            return optional;
        }
        catch (Exception e) {
            logger.error("Got:\n" + response, (Throwable)e);
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected HttpURLConnection openConnection(URL url) throws Exception {
        if (mockedRestClient == null) {
            return (HttpURLConnection)url.openConnection();
        }
        return mockedRestClient.openConnection(url);
    }

    protected String getResponse(HttpURLConnection conn) throws Exception {
        if (mockedRestClient == null) {
            InputStream inputStream = conn.getInputStream();
            byte[] targetArray = new byte[inputStream.available()];
            inputStream.read(targetArray);
            return new String(targetArray, StandardCharsets.UTF_8);
        }
        return mockedRestClient.getResponse(conn);
    }

    public static void mock(RestClient mock) {
        mockedRestClient = mock;
    }
}

