/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.semantic;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.gitchangelog.internal.semantic.ConventionalCommitParser;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersion;

public class SemanticVersioning {
    private final List<String> commits;
    private final Pattern majorPattern;
    private final Pattern minorPattern;
    private final Pattern patchPattern;

    public SemanticVersioning(List<String> tags, List<String> commits, String majorPattern, String minorPattern, String patchPattern) {
        this.commits = commits;
        this.majorPattern = majorPattern != null ? Pattern.compile(majorPattern) : null;
        this.minorPattern = Pattern.compile(minorPattern);
        this.patchPattern = patchPattern != null ? Pattern.compile(patchPattern) : null;
    }

    public SemanticVersion getNextVersion(SemanticVersion highestVersion) {
        VERSION_STEP versionStep = this.getVersionStep();
        if (versionStep == VERSION_STEP.MAJOR) {
            return new SemanticVersion(highestVersion.getMajor() + 1, 0, 0, versionStep);
        }
        if (versionStep == VERSION_STEP.MINOR) {
            return new SemanticVersion(highestVersion.getMajor(), highestVersion.getMinor() + 1, 0, versionStep);
        }
        if (versionStep == VERSION_STEP.PATCH) {
            return new SemanticVersion(highestVersion.getMajor(), highestVersion.getMinor(), highestVersion.getPatch() + 1, versionStep);
        }
        return new SemanticVersion(highestVersion.getMajor(), highestVersion.getMinor(), highestVersion.getPatch(), versionStep);
    }

    public static SemanticVersion getHighestVersion(List<String> tags) {
        SemanticVersion highest = new SemanticVersion(0, 0, 0);
        for (String tag : tags) {
            Matcher semanticVersionMatcher = Pattern.compile("[0-9]+\\.[0-9]+\\.?[0-9]+?").matcher(tag);
            if (!semanticVersionMatcher.find()) continue;
            String[] dotParts = semanticVersionMatcher.group().split("\\.");
            Integer patch = 0;
            if (dotParts.length > 2) {
                patch = new Integer(dotParts[2]);
            }
            SemanticVersion candidate = new SemanticVersion(new Integer(dotParts[0]), new Integer(dotParts[1]), patch);
            candidate.setTag(tag);
            if (candidate.getMajor() > highest.getMajor()) {
                highest = candidate;
                continue;
            }
            if (candidate.getMajor() == highest.getMajor() && candidate.getMinor() > highest.getMinor()) {
                highest = candidate;
                continue;
            }
            if (candidate.getMajor() != highest.getMajor() || candidate.getMinor() != highest.getMinor() || candidate.getPatch() <= highest.getPatch()) continue;
            highest = candidate;
        }
        return highest;
    }

    private VERSION_STEP getVersionStep() {
        boolean patchVersionPatternGiven = this.patchPattern != null;
        VERSION_STEP versionStep = patchVersionPatternGiven ? VERSION_STEP.NONE : VERSION_STEP.PATCH;
        for (String commit : this.commits) {
            boolean majorPatternMatches;
            boolean bl = majorPatternMatches = this.majorPattern != null && this.majorPattern.matcher(commit).find();
            if (majorPatternMatches || ConventionalCommitParser.commitBreaking(commit)) {
                return VERSION_STEP.MAJOR;
            }
            if (this.minorPattern.matcher(commit).find()) {
                versionStep = VERSION_STEP.MINOR;
                continue;
            }
            if (versionStep != VERSION_STEP.NONE || !patchVersionPatternGiven || !this.patchPattern.matcher(commit).find()) continue;
            versionStep = VERSION_STEP.PATCH;
        }
        return versionStep;
    }

    public static enum VERSION_STEP {
        MAJOR,
        MINOR,
        PATCH,
        NONE;

    }
}

