/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.settings;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.gitchangelog.internal.settings.Settings;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class IssuesUtil {
    private final Settings settings;

    public IssuesUtil(Settings settings) {
        this.settings = settings;
    }

    public List<SettingsIssue> getIssues() {
        ArrayList<SettingsIssue> issues = new ArrayList<SettingsIssue>(this.settings.getCustomIssues());
        if (this.settings.isJiraEnabled()) {
            this.addJira(issues);
        }
        if (this.settings.isGitHubEnabled()) {
            this.addGitHub(issues);
        }
        if (this.settings.isGitLabEnabled()) {
            this.addGitLab(issues);
        }
        if (this.settings.isRedmineEnabled()) {
            this.addRedmine(issues);
        }
        return issues;
    }

    private void addGitHub(List<SettingsIssue> issues) {
        if (!Preconditions.isNullOrEmpty(this.settings.getGitHubIssuePattern()) && this.settings.getGitHubApi().isPresent()) {
            issues.add(new SettingsIssue(SettingsIssueType.GITHUB, "GitHub", this.settings.getGitHubIssuePattern(), null, null));
        }
    }

    private void addGitLab(List<SettingsIssue> issues) {
        if (!Preconditions.isNullOrEmpty(this.settings.getGitLabIssuePattern()) && this.settings.getGitLabServer().isPresent()) {
            issues.add(new SettingsIssue(SettingsIssueType.GITLAB, "GitLab", this.settings.getGitLabIssuePattern(), null, null));
        }
    }

    private void addJira(List<SettingsIssue> issues) {
        if (!Preconditions.isNullOrEmpty(this.settings.getJiraIssuePattern())) {
            if (this.settings.getJiraServer().isPresent()) {
                issues.add(new SettingsIssue(SettingsIssueType.JIRA, "Jira", this.settings.getJiraIssuePattern(), this.settings.getJiraServer().orElse("") + "/browse/${PATTERN_GROUP}", null));
            } else {
                issues.add(new SettingsIssue(SettingsIssueType.JIRA, "Jira", this.settings.getJiraIssuePattern(), this.settings.getJiraServer().orElse(null), null));
            }
        }
    }

    private void addRedmine(List<SettingsIssue> issues) {
        if (!Preconditions.isNullOrEmpty(this.settings.getRedmineIssuePattern())) {
            if (this.settings.getRedmineServer().isPresent()) {
                issues.add(new SettingsIssue(SettingsIssueType.REDMINE, "Redmine", this.settings.getRedmineIssuePattern(), this.settings.getRedmineServer().orElse("") + "/issues/${PATTERN_GROUP}", null));
            } else {
                issues.add(new SettingsIssue(SettingsIssueType.REDMINE, "Redmine", this.settings.getRedmineIssuePattern(), this.settings.getRedmineServer().orElse(null), null));
            }
        }
    }
}

