/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.model;

import java.io.Serializable;
import java.util.List;
import se.bjurr.gitchangelog.api.model.Author;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.Issue;
import se.bjurr.gitchangelog.api.model.IssueType;
import se.bjurr.gitchangelog.api.model.Tag;
import se.bjurr.gitchangelog.api.model.interfaces.IAuthors;
import se.bjurr.gitchangelog.api.model.interfaces.ICommits;
import se.bjurr.gitchangelog.api.model.interfaces.IIssues;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class Changelog
implements ICommits,
IAuthors,
IIssues,
Serializable {
    private static final long serialVersionUID = 2193789018496738737L;
    private final List<Commit> commits;
    private final List<Tag> tags;
    private final List<Author> authors;
    private final List<Issue> issues;
    private final List<IssueType> issueTypes;
    private final String ownerName;
    private final String repoName;
    private final List<String> urlParts;

    public Changelog(List<Commit> commits, List<Tag> tags, List<Author> authors, List<Issue> issues, List<IssueType> issueTypes, String ownerName, String repoName, List<String> urlParts) {
        this.commits = Preconditions.checkNotNull(commits, "commits");
        this.tags = Preconditions.checkNotNull(tags, "tags");
        this.authors = Preconditions.checkNotNull(authors, "authors");
        this.issues = Preconditions.checkNotNull(issues, "issues");
        this.issueTypes = Preconditions.checkNotNull(issueTypes, "issueTypes");
        this.ownerName = ownerName;
        this.repoName = repoName;
        this.urlParts = urlParts;
    }

    @Override
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    @Override
    public List<Commit> getCommits() {
        return this.commits;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public List<IssueType> getIssueTypes() {
        return this.issueTypes;
    }

    public List<String> getUrlParts() {
        return this.urlParts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authors == null ? 0 : this.authors.hashCode());
        result = 31 * result + (this.commits == null ? 0 : this.commits.hashCode());
        result = 31 * result + (this.issueTypes == null ? 0 : this.issueTypes.hashCode());
        result = 31 * result + (this.issues == null ? 0 : this.issues.hashCode());
        result = 31 * result + (this.ownerName == null ? 0 : this.ownerName.hashCode());
        result = 31 * result + (this.repoName == null ? 0 : this.repoName.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Changelog other = (Changelog)obj;
        if (this.authors == null ? other.authors != null : !this.authors.equals(other.authors)) {
            return false;
        }
        if (this.commits == null ? other.commits != null : !this.commits.equals(other.commits)) {
            return false;
        }
        if (this.issueTypes == null ? other.issueTypes != null : !this.issueTypes.equals(other.issueTypes)) {
            return false;
        }
        if (this.issues == null ? other.issues != null : !this.issues.equals(other.issues)) {
            return false;
        }
        if (this.ownerName == null ? other.ownerName != null : !this.ownerName.equals(other.ownerName)) {
            return false;
        }
        if (this.repoName == null ? other.repoName != null : !this.repoName.equals(other.repoName)) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }
}

