/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.redmine;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import java.util.Optional;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.redmine.RedmineIssue;

public abstract class RedmineClient {
    private final String api;

    public RedmineClient(String api) {
        this.api = api.endsWith("/") ? api.substring(0, api.length() - 1) : api;
    }

    public String getApi() {
        return this.api;
    }

    protected String getEndpoint(String issue) {
        String issueNo = this.getIssueNumber(issue);
        String endpoint = this.api + "/issues/" + issueNo + ".json";
        return endpoint;
    }

    protected RedmineIssue toRedmineIssue(String issue, String json) {
        String issueNo = this.getIssueNumber(issue);
        String title = (String)JsonPath.read((String)json, (String)"$.issue.subject", (Predicate[])new Predicate[0]);
        String description = (String)JsonPath.read((String)json, (String)"$.issue.description", (Predicate[])new Predicate[0]);
        String type = (String)JsonPath.read((String)json, (String)"$.issue.tracker.name", (Predicate[])new Predicate[0]);
        String link = this.api + "/issues/" + issueNo;
        RedmineIssue redmineIssue = new RedmineIssue(title, description, link, issue, type);
        return redmineIssue;
    }

    protected String getIssueNumber(String issue) {
        return issue.startsWith("#") ? issue.substring(1) : issue;
    }

    public abstract RedmineClient withBasicCredentials(String var1, String var2);

    public abstract RedmineClient withTokenCredentials(String var1);

    public abstract RedmineClient withHeaders(Map<String, String> var1);

    public abstract Optional<RedmineIssue> getIssue(String var1) throws GitChangelogIntegrationException;
}

