/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubService;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class GitHubServiceFactory {
    static Interceptor interceptor;

    public static void setInterceptor(Interceptor interceptor) {
        GitHubServiceFactory.interceptor = interceptor;
    }

    public static synchronized GitHubService getGitHubService(String api, Optional<String> token) {
        if (!api.endsWith("/")) {
            api = api + "/";
        }
        File cacheDir = new File(".okhttpcache");
        cacheDir.mkdir();
        Cache cache = new Cache(cacheDir, 0xA00000L);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cache(cache).connectTimeout(10L, TimeUnit.SECONDS);
        if (token != null && token.isPresent() && !token.get().isEmpty()) {
            builder.addInterceptor(chain -> {
                Request original = chain.request();
                Request request = original.newBuilder().addHeader("Authorization", "token " + (String)token.get()).method(original.method(), original.body()).build();
                return chain.proceed(request);
            });
        }
        if (interceptor != null) {
            builder.addInterceptor(interceptor);
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(api).client(builder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        return (GitHubService)retrofit.create(GitHubService.class);
    }
}

