/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;
import se.bjurr.gitchangelog.api.InclusivenessStrategy;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogRepositoryException;
import se.bjurr.gitchangelog.api.helpers.Helpers;
import se.bjurr.gitchangelog.api.model.Changelog;
import se.bjurr.gitchangelog.internal.git.GitRepo;
import se.bjurr.gitchangelog.internal.git.GitRepoData;
import se.bjurr.gitchangelog.internal.git.GitRepoDataHelper;
import se.bjurr.gitchangelog.internal.git.RevisionBoundary;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.issues.IssueParser;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.model.Transformer;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersion;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersioning;
import se.bjurr.gitchangelog.internal.settings.Settings;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;
import se.bjurr.gitchangelog.internal.util.ResourceLoader;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class GitChangelogApi {
    private Settings settings;
    private String templateContent;
    private Handlebars handlebars;
    private final AtomicInteger helperCounter = new AtomicInteger();

    public static GitChangelogApi gitChangelogApiBuilder() {
        return new GitChangelogApi();
    }

    private GitChangelogApi() {
        this.settings = new Settings();
        this.handlebars = new Handlebars();
        this.handlebars.setPrettyPrint(true);
        this.handlebars.registerHelpers(StringHelpers.class);
        for (Map.Entry<String, Helper<?>> helper : Helpers.getAll().entrySet()) {
            this.handlebars.registerHelper(helper.getKey(), helper.getValue());
        }
    }

    private GitChangelogApi(Settings settings) {
        this.settings = settings;
    }

    public Changelog getChangelog() throws GitChangelogRepositoryException {
        return this.getChangelog(true);
    }

    private Changelog getChangelog(boolean useIntegrations) throws GitChangelogRepositoryException {
        Changelog changelog;
        GitRepo gitRepo = new GitRepo(new File(this.settings.getFromRepo()));
        try {
            changelog = this.getChangelog(gitRepo, useIntegrations);
        }
        catch (Throwable throwable) {
            try {
                try {
                    gitRepo.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GitChangelogRepositoryException("", e);
            }
        }
        gitRepo.close();
        return changelog;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void render(Writer writer) throws GitChangelogRepositoryException {
        Template template;
        String templateString = this.getTemplateString();
        if (this.settings.getTemplateBaseDir() != null) {
            this.handlebars.with(new TemplateLoader[]{new FileTemplateLoader(this.settings.getTemplateBaseDir(), this.settings.getTemplateSuffix())});
        }
        try {
            template = this.handlebars.compileInline(templateString);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot render:\n\n" + templateString, e);
        }
        try {
            Map<String, Object> extendedVariables = this.settings.getExtendedVariables();
            if (extendedVariables == null) {
                throw new IllegalStateException("extendedVariables cannot be null");
            }
            Changelog changelog = this.getChangelog(this.settings.isUseIntegrations());
            Context changelogContext = Context.newContext((Object)changelog).combine(extendedVariables);
            template.apply(changelogContext, writer);
        }
        catch (IOException e) {
            throw new GitChangelogRepositoryException("", e);
        }
    }

    public String getTemplateString() {
        if (this.templateContent != null) {
            return this.templateContent;
        }
        String resourceName = this.settings.getTemplatePath();
        return ResourceLoader.getResourceOrFile(resourceName, this.settings.getEncoding());
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public String render() throws GitChangelogRepositoryException {
        StringWriter writer = new StringWriter();
        this.render(writer);
        return ((Object)writer).toString();
    }

    public void toFile(File file) throws GitChangelogRepositoryException, IOException {
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            boolean folderExists;
            boolean bl = folderExists = parentFile.exists() || parentFile.mkdirs();
            if (!folderExists) {
                throw new RuntimeException("Folder " + parentFile.getAbsolutePath() + " cannot be created");
            }
        }
        Files.write(file.toPath(), this.render().getBytes(this.settings.getEncoding()), new OpenOption[0]);
    }

    public void prependToFile(File file) throws GitChangelogRepositoryException, IOException {
        if (!file.exists()) {
            this.toFile(file);
            return;
        }
        byte[] bytesToPrepend = this.render().getBytes(this.settings.getEncoding());
        byte[] originalBytes = Files.readAllBytes(file.toPath());
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            outputStream.write(bytesToPrepend);
            outputStream.write(originalBytes);
        }
    }

    public SemanticVersion getNextSemanticVersion() throws GitChangelogRepositoryException {
        Optional<String> tag;
        GitChangelogApi api = GitChangelogApi.gitChangelogApiBuilder();
        api.settings = this.settings.copy();
        boolean fromGiven = api.getSettings().getFromRevision().isPresent();
        SemanticVersion highestSemanticVersion = api.getHighestSemanticVersion();
        if (!fromGiven && (tag = highestSemanticVersion.findTag()).isPresent()) {
            api.withFromRevision(tag.get());
        }
        Changelog changelog = api.getChangelog(false);
        api.getTagsAsStrings(changelog);
        List<String> commits = api.getCommitMessages(changelog);
        String majorVersionPattern = api.settings.getSemanticMajorPattern().orElse(null);
        String minorVersionPattern = api.settings.getSemanticMinorPattern();
        String patchVersionPattern = api.settings.getSemanticPatchPattern();
        SemanticVersioning semanticVersioning = new SemanticVersioning(commits, majorVersionPattern, minorVersionPattern, patchVersionPattern);
        return semanticVersioning.getNextVersion(highestSemanticVersion);
    }

    public SemanticVersion getHighestSemanticVersion() throws GitChangelogRepositoryException {
        Changelog changelog = this.getChangelog(false);
        List<String> tags = this.getTagsAsStrings(changelog);
        return SemanticVersioning.getHighestVersion(tags);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SemanticVersion getCurrentSemanticVersion() throws Exception {
        try (GitRepo gitRepo = new GitRepo(new File(this.settings.getFromRepo()));){
            RevisionBoundary<ObjectId> from = this.getFrom(gitRepo, this.settings);
            RevisionBoundary<ObjectId> to = this.getTo(gitRepo, this.settings);
            List<String> tags = gitRepo.getTags(from, to).stream().map(it -> Transformer.toReadableTagName(it, this.settings.getReadableTagName())).collect(Collectors.toList());
            if (tags.isEmpty()) return this.getNextSemanticVersion();
            SemanticVersion semanticVersion = SemanticVersioning.getHighestVersion(tags);
            return semanticVersion;
        }
        catch (IOException e) {
            throw new GitChangelogRepositoryException("", e);
        }
    }

    private List<String> getCommitMessages(Changelog changelog) {
        return changelog.getCommits().stream().map(it -> it.getMessage()).collect(Collectors.toList());
    }

    private List<String> getTagsAsStrings(Changelog changelog) {
        return changelog.getTags().stream().map(it -> it.getName()).collect(Collectors.toList());
    }

    public GitChangelogApi withSemanticMajorVersionPattern(String major) throws GitChangelogRepositoryException {
        this.settings.setSemanticMajorPattern(major);
        return this;
    }

    public GitChangelogApi withSemanticMinorVersionPattern(String minor) throws GitChangelogRepositoryException {
        this.settings.setSemanticMinorPattern(minor);
        return this;
    }

    public GitChangelogApi withSemanticPatchVersionPattern(String patch) throws GitChangelogRepositoryException {
        this.settings.setSemanticPatchPattern(patch);
        return this;
    }

    public GitChangelogApi withHandlebarsHelper(String javascriptHelper) throws GitChangelogRepositoryException, IOException {
        int helperIndex = this.helperCounter.getAndIncrement();
        this.handlebars.registerHelpers("helper-" + helperIndex, javascriptHelper);
        return this;
    }

    public GitChangelogApi withHandlebarsHelper(String name, Helper<?> helper) throws GitChangelogRepositoryException, IOException {
        this.handlebars.registerHelper(name, helper);
        return this;
    }

    public GitChangelogApi withCustomIssue(String name, String pattern, String link, String title) {
        this.settings.addCustomIssue(new SettingsIssue(name, pattern, link, title));
        return this;
    }

    public GitChangelogApi withDateFormat(String dateFormat) {
        this.settings.setDateFormat(dateFormat);
        return this;
    }

    public GitChangelogApi withExtendedVariables(Map<String, Object> extendedVariables) {
        this.settings.setExtendedVariables(extendedVariables);
        return this;
    }

    public GitChangelogApi withExtendedHeaders(Map<String, String> extendedHeaders) {
        this.settings.setExtendedRestHeaders(extendedHeaders);
        return this;
    }

    public GitChangelogApi withFromRevision(String revision, InclusivenessStrategy strategy) {
        this.settings.setFromRevision(revision);
        this.settings.setFromRevisionStrategy(strategy);
        return this;
    }

    public GitChangelogApi withFromRevision(String fromRevision) {
        return this.withFromRevision(fromRevision, InclusivenessStrategy.DEFAULT);
    }

    @Deprecated
    public GitChangelogApi withFromCommit(String fromCommit) {
        return this.withFromRevision(fromCommit);
    }

    @Deprecated
    public GitChangelogApi withFromRef(String fromBranch) {
        return this.withFromRevision(fromBranch);
    }

    public GitChangelogApi withFromRepo(String fromRepo) {
        this.settings.setFromRepo(fromRepo);
        return this;
    }

    public GitChangelogApi withFromRepo(File fromRepo) {
        this.settings.setFromRepo(fromRepo.getAbsolutePath());
        return this;
    }

    public GitChangelogApi withGitHubApi(String gitHubApi) {
        this.settings.setGitHubApi(gitHubApi);
        return this;
    }

    public GitChangelogApi withGitHubIssuePattern(String gitHubIssuePattern) {
        this.settings.setGitHubIssuePattern(gitHubIssuePattern);
        return this;
    }

    public GitChangelogApi withGitHubToken(String gitHubToken) {
        this.settings.setGitHubToken(gitHubToken);
        return this;
    }

    public GitChangelogApi withGitLabIssuePattern(String gitLabIssuePattern) {
        this.settings.setGitLabIssuePattern(gitLabIssuePattern);
        return this;
    }

    public GitChangelogApi withGitLabProjectName(String gitLabProjectName) {
        this.settings.setGitLabProjectName(gitLabProjectName);
        return this;
    }

    public GitChangelogApi withGitLabServer(String gitLabServer) {
        this.settings.setGitLabServer(gitLabServer);
        return this;
    }

    public GitChangelogApi withGitLabToken(String gitLabToken) {
        this.settings.setGitLabToken(gitLabToken);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsWithMessage(String ignoreCommitsIfMessageMatches) {
        this.settings.setIgnoreCommitsIfMessageMatches(ignoreCommitsIfMessageMatches);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsOlderThan(Date ignoreCommitsIfOlderThan) {
        this.settings.setIgnoreCommitsIfOlderThan(ignoreCommitsIfOlderThan);
        return this;
    }

    public GitChangelogApi withIgnoreCommitsWithoutIssue(boolean ignoreCommitsWithoutIssue) {
        this.settings.setIgnoreCommitsWithoutIssue(ignoreCommitsWithoutIssue);
        return this;
    }

    public GitChangelogApi withIgnoreTagsIfNameMatches(String ignoreTagsIfNameMatches) {
        this.settings.setIgnoreTagsIfNameMatches(ignoreTagsIfNameMatches);
        return this;
    }

    public GitChangelogApi withJiraIssuePattern(String jiraIssuePattern) {
        this.settings.setJiraIssuePattern(jiraIssuePattern);
        return this;
    }

    public GitChangelogApi withJiraPassword(String string) {
        this.settings.setJiraPassword(string);
        return this;
    }

    public GitChangelogApi withJiraBasicAuthString(String string) {
        this.settings.setJiraToken(string);
        return this;
    }

    public GitChangelogApi withJiraBearer(String string) {
        this.settings.setJiraBearer(string);
        return this;
    }

    public GitChangelogApi withJiraServer(String jiraServer) {
        this.settings.setJiraServer(jiraServer);
        return this;
    }

    public GitChangelogApi withJiraUsername(String string) {
        this.settings.setJiraUsername(string);
        return this;
    }

    public GitChangelogApi withRedmineIssuePattern(String redmineIssuePattern) {
        this.settings.setRedmineIssuePattern(redmineIssuePattern);
        return this;
    }

    public GitChangelogApi withRedminePassword(String string) {
        this.settings.setRedminePassword(string);
        return this;
    }

    public GitChangelogApi withRedmineToken(String string) {
        this.settings.setRedmineToken(string);
        return this;
    }

    public GitChangelogApi withRedmineServer(String redmineServer) {
        this.settings.setRedmineServer(redmineServer);
        return this;
    }

    public GitChangelogApi withRedmineUsername(String string) {
        this.settings.setRedmineUsername(string);
        return this;
    }

    public GitChangelogApi withJiraIssueAdditionalField(String field) {
        this.settings.addJiraIssueAdditionalField(field);
        return this;
    }

    public GitChangelogApi withNoIssueName(String noIssueName) {
        this.settings.setNoIssueName(noIssueName);
        return this;
    }

    public GitChangelogApi withReadableTagName(String readableTagName) {
        this.settings.setReadableTagName(readableTagName);
        return this;
    }

    public GitChangelogApi withRemoveIssueFromMessageArgument(boolean removeIssueFromMessage) {
        this.settings.setRemoveIssueFromMessage(removeIssueFromMessage);
        return this;
    }

    public GitChangelogApi withSettings(URL url) {
        this.settings = Settings.fromFile(url);
        return this;
    }

    public GitChangelogApi withTemplateContent(String templateContent) {
        this.templateContent = templateContent;
        return this;
    }

    public GitChangelogApi withTemplatePath(String templatePath) {
        this.settings.setTemplatePath(templatePath);
        return this;
    }

    public GitChangelogApi withTemplateBaseDir(String templateBaseDir) {
        this.settings.setTemplateBaseDir(templateBaseDir);
        return this;
    }

    public GitChangelogApi withTemplateSuffix(String templateSuffix) {
        this.settings.setTemplateSuffix(templateSuffix);
        return this;
    }

    public GitChangelogApi withUseIntegrations(boolean useIntegrations) {
        this.settings.setUseIntegrations(useIntegrations);
        return this;
    }

    public GitChangelogApi withTimeZone(String timeZone) {
        this.settings.setTimeZone(timeZone);
        return this;
    }

    public GitChangelogApi withToRevision(String revision, InclusivenessStrategy strategy) {
        this.settings.setToRevision(revision);
        this.settings.setToRevisionStrategy(strategy);
        return this;
    }

    public GitChangelogApi withToRevision(String toRevision) {
        return this.withToRevision(toRevision, InclusivenessStrategy.DEFAULT);
    }

    @Deprecated
    public GitChangelogApi withToCommit(String toCommit) {
        return this.withToRevision(toCommit);
    }

    @Deprecated
    public GitChangelogApi withToRef(String toBranch) {
        return this.withToRevision(toBranch);
    }

    public GitChangelogApi withPathFilters(String ... pathFilters) {
        this.settings.setPathFilters(Arrays.asList(pathFilters));
        return this;
    }

    public GitChangelogApi withUntaggedName(String untaggedName) {
        this.settings.setUntaggedName(untaggedName);
        return this;
    }

    private Changelog getChangelog(GitRepo gitRepo, boolean useIntegrations) throws GitChangelogRepositoryException {
        gitRepo.setPathFilters(this.settings.getPathFilters());
        RevisionBoundary<ObjectId> fromId = this.getFrom(gitRepo, this.settings);
        RevisionBoundary<ObjectId> toId = this.getTo(gitRepo, this.settings);
        GitRepoData gitRepoData = gitRepo.getGitRepoData(fromId, toId, this.settings.getUntaggedName(), this.settings.getIgnoreTagsIfNameMatches());
        if (!this.settings.getGitHubApi().isPresent()) {
            this.settings.setGitHubApi(gitRepoData.findGitHubApi().orElse(null));
        }
        if (!this.settings.getGitLabServer().isPresent()) {
            this.settings.setGitLabServer(gitRepoData.findGitLabServer().orElse(null));
            this.settings.setGitLabProjectName(gitRepoData.findOwnerName().orElse(null));
        }
        List<GitCommit> diff = gitRepoData.getGitCommits();
        List<ParsedIssue> issues = new IssueParser(this.settings, diff).parseForIssues(useIntegrations);
        if (this.settings.ignoreCommitsWithoutIssue()) {
            gitRepoData = GitRepoDataHelper.removeCommitsWithoutIssue(issues, gitRepoData);
            diff = gitRepoData.getGitCommits();
        }
        List<GitTag> tags = gitRepoData.getGitTags();
        Transformer transformer = new Transformer(this.settings);
        return new Changelog(transformer.toCommits(diff), transformer.toTags(tags, issues), transformer.toAuthors(diff), transformer.toIssues(issues), transformer.toIssueTypes(issues), gitRepoData.findOwnerName().orElse(null), gitRepoData.findRepoName().orElse(null), gitRepoData.getUrlPartsList());
    }

    private RevisionBoundary<ObjectId> getTo(GitRepo gitRepo, Settings settings) throws GitChangelogRepositoryException {
        Optional<RevisionBoundary<ObjectId>> toIdOpt = this.getId(gitRepo, settings.getToRevision(), settings.getToRevisionStrategy());
        if (toIdOpt.isPresent()) {
            return toIdOpt.get();
        }
        Optional<ObjectId> headOpt = gitRepo.findRef("HEAD");
        if (headOpt.isPresent()) {
            return new RevisionBoundary<ObjectId>(headOpt.get(), InclusivenessStrategy.INCLUSIVE);
        }
        return new RevisionBoundary<ObjectId>(gitRepo.getRef("master"), InclusivenessStrategy.INCLUSIVE);
    }

    private RevisionBoundary<ObjectId> getFrom(GitRepo gitRepo, Settings settings) throws GitChangelogRepositoryException {
        return this.getId(gitRepo, settings.getFromRevision(), settings.getFromRevisionStrategy()).orElse(new RevisionBoundary<ObjectId>(gitRepo.getCommit("0000000000000000000000000000000000000000"), InclusivenessStrategy.INCLUSIVE));
    }

    private Optional<RevisionBoundary<ObjectId>> getId(GitRepo gitRepo, Optional<String> revision, InclusivenessStrategy inclusivenessStrategy) throws GitChangelogRepositoryException {
        if (!revision.isPresent()) {
            return Optional.empty();
        }
        return gitRepo.findObjectId(revision.get(), inclusivenessStrategy);
    }

    public GitChangelogApi withJiraEnabled(boolean b) {
        this.settings.setJiraEnabled(b);
        return this;
    }

    public GitChangelogApi withGitLabEnabled(boolean b) {
        this.settings.setGitLabEnabled(b);
        return this;
    }

    public GitChangelogApi withGitHubEnabled(boolean b) {
        this.settings.setGitHubEnabled(b);
        return this;
    }

    public GitChangelogApi withRedmineEnabled(boolean b) {
        this.settings.setRedmineEnabled(b);
        return this;
    }

    public GitChangelogApi withEncoding(Charset encoding) {
        this.settings.setEncoding(encoding);
        return this;
    }
}

