/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.model.interfaces.IGitCommitReferer;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class ParsedIssue
implements IGitCommitReferer {
    private final List<GitCommit> gitCommits = new ArrayList<GitCommit>();
    private final String name;
    private final String title;
    private final String link;
    private final String issue;
    private final String issueType;
    private final List<String> linkedIssues;
    private final List<String> labels;
    private final String description;
    private final SettingsIssueType settingsIssueType;
    private final Map<String, Object> additionalFields;

    public ParsedIssue(SettingsIssueType settingsIssueType, String name, String issue, String description, String link, String title, String issueType, List<String> linkedIssues, List<String> labels, Map<String, Object> additionalFields) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.title = Preconditions.emptyToNull(title);
        this.issue = issue;
        this.link = link;
        this.issueType = issueType;
        this.settingsIssueType = settingsIssueType;
        this.linkedIssues = linkedIssues;
        this.labels = labels;
        this.description = description;
        this.additionalFields = additionalFields;
    }

    public SettingsIssueType getSettingsIssueType() {
        return this.settingsIssueType;
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    public GitCommit getGitCommit() {
        return Preconditions.checkNotNull(this.gitCommits.get(0), this.name);
    }

    public List<GitCommit> getGitCommits() {
        return this.gitCommits;
    }

    public String getLink() {
        return this.link;
    }

    public String getIssueType() {
        return this.issueType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + this.issue;
    }

    public void addCommit(GitCommit gitCommit) {
        this.gitCommits.add(gitCommit);
    }

    public String getIssue() {
        return this.issue;
    }

    public String getDescription() {
        return this.description;
    }

    public void addCommits(List<GitCommit> commits) {
        this.gitCommits.addAll(commits);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getLinkedIssues() {
        return this.linkedIssues;
    }

    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParsedIssue other = (ParsedIssue)obj;
        return Objects.equals(this.name, other.name);
    }
}

