/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.semantic;

import com.github.jknack.handlebars.Options;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.Issue;
import se.bjurr.gitchangelog.api.model.Tag;
import se.bjurr.gitchangelog.internal.model.Transformer;

@SuppressFBWarnings(value={"REDOS"})
public class ConventionalCommitParser {
    private static final Pattern CONVENTIONAL_PATTERN = Pattern.compile("^(\\w+)(\\(([\\w\\-\\.\\,\\s:]+)\\)?)?(\\!?)[\\s?]*:(.+)");
    private static final Pattern FOOTER_PATTERN = Pattern.compile("^(BREAKING[ -]CHANGE|[^ ]+)(((: )|( #))(.+))");

    public static String getDate(String tagTime) {
        if (tagTime == null || !tagTime.contains(" ")) {
            return "";
        }
        return tagTime.split(" ")[0];
    }

    public static boolean commitScope(Commit commit, Options options) {
        String scope = options.hash("scope").toString();
        return ConventionalCommitParser.commitScopes(commit.getMessage()).stream().filter(it -> it.matches(scope)).findFirst().isPresent();
    }

    public static String revertedCommit(Object commitMessage) {
        Matcher matcher = Transformer.PATTERN_THIS_REVERTS.matcher(commitMessage.toString());
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    public static List<String> commitFixes(Object commitMessage) {
        Matcher matcher = Pattern.compile("\\(fixes ([^)]+)").matcher(commitMessage.toString());
        if (!matcher.find()) {
            return new ArrayList<String>();
        }
        String group = matcher.group(1);
        String value = group == null ? "" : group;
        return Arrays.stream(value.split(" ")).map(it -> it.trim()).collect(Collectors.toList());
    }

    public static List<String> commitRefs(Object commitMessage) {
        Matcher matcher = Pattern.compile("\\(refs ([^)]+)").matcher(commitMessage.toString());
        if (!matcher.find()) {
            return new ArrayList<String>();
        }
        String group = matcher.group(1);
        String value = group == null ? "" : group;
        return Arrays.stream(value.split(" ")).map(it -> it.trim()).collect(Collectors.toList());
    }

    public static String commitDescription(Object commitMessage) {
        String value;
        Matcher matcher = CONVENTIONAL_PATTERN.matcher(commitMessage.toString());
        if (!matcher.find()) {
            return "";
        }
        String group = matcher.group(5);
        String string = value = group == null ? "" : group;
        if (value.indexOf("(refs ") != -1) {
            value = value.substring(0, value.indexOf("(refs "));
        }
        if (value.indexOf("(fixes ") != -1) {
            value = value.substring(0, value.indexOf("(fixes "));
        }
        return value.trim();
    }

    public static List<String> commitScopes(Object commitMessage) {
        Matcher matcher = CONVENTIONAL_PATTERN.matcher(commitMessage.toString());
        if (!matcher.find()) {
            return new ArrayList<String>();
        }
        String group = matcher.group(3);
        if (group == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(group.split("[:,]")).map(it -> it.trim()).collect(Collectors.toList());
    }

    public static boolean commitBreaking(String commitMessage) {
        String value;
        String type = ConventionalCommitParser.getType(commitMessage);
        if (type.matches("[Bb]reaking")) {
            return true;
        }
        Matcher matcher = CONVENTIONAL_PATTERN.matcher(commitMessage);
        if (!matcher.find()) {
            return false;
        }
        String group = matcher.group(4);
        String string = value = group == null ? "" : group;
        if (value.equals("!")) {
            return true;
        }
        for (Footer footer : ConventionalCommitParser.getMessageParts((String)commitMessage).footers) {
            if (!footer.token.equals("BREAKING CHANGE") && !footer.token.equals("BREAKING-CHANGE")) continue;
            return true;
        }
        return false;
    }

    public static boolean containsBreaking(List<Commit> commits, Options options) {
        for (Commit commit : commits) {
            if (!ConventionalCommitParser.commitBreaking(commit.getMessage())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsType(List<Commit> commits, Options options) {
        for (Commit commit : commits) {
            if (!ConventionalCommitParser.commitType(commit.getMessage(), options)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTypeOtherThan(List<Commit> commits, Options options) {
        for (Commit commit : commits) {
            if (ConventionalCommitParser.commitType(commit.getMessage(), options)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIssueType(List<Issue> issues, Options options) {
        for (Issue issue : issues) {
            if (!ConventionalCommitParser.issueType(issue.getType(), options)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIssueTypeOtherThan(List<Issue> issues, Options options) {
        for (Issue issue : issues) {
            if (ConventionalCommitParser.issueType(issue.getType(), options)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIssueLabel(List<Issue> issues, Options options) {
        for (Issue issue : issues) {
            if (!ConventionalCommitParser.issueLabel(issue, options)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIssueLabelOtherThan(List<Issue> issues, Options options) {
        for (Issue issue : issues) {
            if (ConventionalCommitParser.issueLabel(issue, options)) continue;
            return true;
        }
        return false;
    }

    public static boolean issueType(String issueType, Options options) {
        String type = (String)options.hash("type");
        return issueType.matches(type);
    }

    public static boolean issueLabel(Issue issue, Options options) {
        boolean result;
        String label = (String)options.hash("label");
        if (!issue.getHasLabels()) {
            result = false;
        } else {
            boolean found = false;
            for (String l : issue.getLabels()) {
                if (!label.equals(l)) continue;
                found = true;
                break;
            }
            result = found;
        }
        return result;
    }

    public static boolean commitType(String commitMessage, Options options) {
        String type = (String)options.hash("type");
        return ConventionalCommitParser.getType(commitMessage).matches(type);
    }

    private static String getType(String commitMessage) {
        Matcher matcher = CONVENTIONAL_PATTERN.matcher(commitMessage);
        if (!matcher.find()) {
            boolean matchesRevert = Transformer.PATTERN_THIS_REVERTS.matcher(commitMessage).find();
            if (matchesRevert) {
                return "revert";
            }
            return "";
        }
        String group = matcher.group(1);
        return group == null ? "" : group.trim();
    }

    public static boolean isReleaseTag(Tag tag) {
        return Pattern.matches("^[0-9]+\\.[0-9]+\\.[0-9]+", tag.getName().replaceAll("[^0-9\\.]", ""));
    }

    public static MessageParts getMessageParts(String commitMessage) {
        MessageParts mp = new MessageParts();
        List<String> lines = Arrays.asList(commitMessage.trim().split("\\r?\\n"));
        boolean paragraphs = true;
        Footer currentFooter = null;
        Object currentParagraph = null;
        for (int i = 1; i < lines.size(); ++i) {
            boolean shouldSaveState;
            boolean isFooter;
            String line = lines.get(i);
            boolean empty = line.trim().isEmpty();
            Footer footerCandidate = ConventionalCommitParser.toFooter(line);
            boolean bl = isFooter = footerCandidate != null;
            if (isFooter && currentFooter == null) {
                paragraphs = false;
                currentFooter = footerCandidate;
            } else if (currentFooter != null) {
                currentFooter.value = currentFooter.value + "\n" + line;
            }
            if (paragraphs && !empty) {
                currentParagraph = currentParagraph == null ? line : (String)currentParagraph + "\n" + line;
            }
            boolean isLastLine = i == lines.size() - 1;
            boolean isNextLineEmpty = !isLastLine && lines.get(i + 1).trim().isEmpty();
            boolean isNextLineNewFooter = !isLastLine && ConventionalCommitParser.toFooter(lines.get(i + 1)) != null;
            boolean bl2 = shouldSaveState = isLastLine || isNextLineEmpty || isNextLineNewFooter;
            if (!shouldSaveState) continue;
            if (currentFooter != null) {
                mp.footers.add(currentFooter);
                currentFooter = null;
            }
            if (currentParagraph == null) continue;
            mp.paragraphs.add((String)currentParagraph);
            currentParagraph = null;
        }
        return mp;
    }

    private static Footer toFooter(String from) {
        Matcher m = FOOTER_PATTERN.matcher(from);
        Footer f = new Footer();
        if (m.find()) {
            f.token = m.group(1);
            f.value = m.group(6);
            return f;
        }
        return null;
    }

    public static class Footer {
        public String token = "";
        public String value = "";

        public String getToken() {
            return this.token;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class MessageParts {
        public List<String> paragraphs = new ArrayList<String>();
        public List<Footer> footers = new ArrayList<Footer>();

        public List<Footer> getFooters() {
            return this.footers;
        }

        public List<String> getParagraphs() {
            return this.paragraphs;
        }
    }
}

