/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.settings;

import com.google.gson.Gson;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import se.bjurr.gitchangelog.api.GitChangelogApiConstants;
import se.bjurr.gitchangelog.api.InclusivenessStrategy;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;

public class Settings
implements Serializable {
    private static final long serialVersionUID = 4565886594381385244L;
    private static Gson gson = new Gson();
    private String fromRepo;
    private String fromRevision;
    private InclusivenessStrategy fromRevisionStrategy;
    private String toRevision;
    private InclusivenessStrategy toRevisionStrategy;
    private String ignoreTagsIfNameMatches;
    private String ignoreCommitsIfMessageMatches;
    private Date ignoreCommitsIfOlderThan;
    private String untaggedName;
    private String templatePath;
    private String templateBaseDir;
    private String templateSuffix;
    private String readableTagName;
    private String dateFormat;
    private String noIssueName;
    private String timeZone;
    private boolean removeIssueFromMessage;
    private boolean jiraEnabled;
    private String jiraServer;
    private String jiraIssuePattern;
    private List<String> jiraIssueAdditionalFields;
    private String jiraUsername;
    private String jiraPassword;
    private String jiraToken;
    private String jiraBearer;
    private boolean redmineEnabled;
    private String redmineServer;
    private String redmineIssuePattern;
    private String redmineUsername;
    private String redminePassword;
    private String redmineToken;
    private boolean gitHubEnabled;
    private String gitHubApi;
    private String gitHubToken;
    private String gitHubIssuePattern;
    private List<SettingsIssue> customIssues;
    private Map<String, Object> extendedVariables = new HashMap<String, Object>();
    private Map<String, String> extendedRestHeaders;
    private boolean ignoreCommitsWithoutIssue;
    private boolean gitLabEnabled;
    private String gitLabServer;
    private String gitLabToken;
    private String gitLabIssuePattern;
    private String gitLabProjectName;
    private String semanticMajorPattern;
    private String semanticMinorPattern;
    private String semanticPatchPattern;
    private boolean useIntegrations;
    private List<String> pathFilters;
    private String encoding = StandardCharsets.UTF_8.name();

    public void setCustomIssues(List<SettingsIssue> customIssues) {
        this.customIssues = customIssues;
    }

    public void setFromRevision(String revision) {
        if (revision == null || revision.trim().isEmpty()) {
            this.fromRevision = null;
            return;
        }
        this.fromRevision = revision.trim();
    }

    public void setFromRevisionStrategy(InclusivenessStrategy fromRevisionStrategy) {
        this.fromRevisionStrategy = fromRevisionStrategy;
    }

    public void setToRevision(String revision) {
        if (revision == null || revision.trim().isEmpty()) {
            this.toRevision = null;
            return;
        }
        this.toRevision = revision.trim();
    }

    public void setToRevisionStrategy(InclusivenessStrategy toRevisionStrategy) {
        this.toRevisionStrategy = toRevisionStrategy;
    }

    public Optional<String> getFromRevision() {
        return Optional.ofNullable(this.fromRevision);
    }

    public InclusivenessStrategy getFromRevisionStrategy() {
        return Optional.ofNullable(this.fromRevisionStrategy).orElse(InclusivenessStrategy.DEFAULT);
    }

    public Optional<String> getToRevision() {
        return Optional.ofNullable(this.toRevision);
    }

    public InclusivenessStrategy getToRevisionStrategy() {
        return Optional.ofNullable(this.toRevisionStrategy).orElse(InclusivenessStrategy.DEFAULT);
    }

    public void setFromRepo(String fromRepo) {
        this.fromRepo = fromRepo;
    }

    public String getFromRepo() {
        return Optional.ofNullable(this.fromRepo).orElse(".");
    }

    public void setIgnoreCommitsIfMessageMatches(String ignoreCommitsIfMessageMatches) {
        this.ignoreCommitsIfMessageMatches = ignoreCommitsIfMessageMatches;
    }

    public void setIgnoreTagsIfNameMatches(String ignoreTagsIfNameMatches) {
        this.ignoreTagsIfNameMatches = ignoreTagsIfNameMatches;
    }

    public void setIgnoreCommitsIfOlderThan(Date ignoreCommitsIfOlderThan) {
        this.ignoreCommitsIfOlderThan = ignoreCommitsIfOlderThan != null ? new Date(ignoreCommitsIfOlderThan.getTime()) : null;
    }

    public void setJiraIssuePattern(String jiraIssuePattern) {
        this.jiraIssuePattern = jiraIssuePattern;
    }

    public void setJiraServer(String jiraServer) {
        this.jiraServer = jiraServer;
    }

    public void setRedmineIssuePattern(String redmineIssuePattern) {
        this.redmineIssuePattern = redmineIssuePattern;
    }

    public void setRedmineServer(String redmineServer) {
        this.redmineServer = redmineServer;
    }

    public void addCustomIssue(SettingsIssue customIssue) {
        if (this.customIssues == null) {
            this.customIssues = new ArrayList<SettingsIssue>();
        }
        this.customIssues.add(customIssue);
    }

    public List<SettingsIssue> getCustomIssues() {
        if (this.customIssues == null) {
            return new ArrayList<SettingsIssue>();
        }
        return this.customIssues;
    }

    public String getIgnoreCommitsIfMessageMatches() {
        return Optional.ofNullable(this.ignoreCommitsIfMessageMatches).orElse("");
    }

    public Optional<Date> getIgnoreCommitsIfOlderThan() {
        return Optional.ofNullable(this.ignoreCommitsIfOlderThan);
    }

    public String getJiraIssuePattern() {
        return Optional.ofNullable(this.jiraIssuePattern).orElse("\\b[a-zA-Z]([a-zA-Z]+)-([0-9]+)\\b");
    }

    public Optional<String> getJiraServer() {
        return Optional.ofNullable(this.jiraServer);
    }

    public String getRedmineIssuePattern() {
        return Optional.ofNullable(this.redmineIssuePattern).orElse("#([0-9]+)");
    }

    public Optional<String> getRedmineServer() {
        return Optional.ofNullable(this.redmineServer);
    }

    public static Settings fromFile(URL url) {
        try {
            String json = new String(Files.readAllBytes(Paths.get(url.toURI())), StandardCharsets.UTF_8);
            return Settings.fromJson(json);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read " + url, e);
        }
    }

    public static Settings fromJson(String json) {
        return (Settings)gson.fromJson(json, Settings.class);
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public Settings copy() {
        return Settings.fromJson(this.toJson());
    }

    public String getUntaggedName() {
        return Optional.ofNullable(this.untaggedName).orElse("Unreleased");
    }

    public Optional<String> getIgnoreTagsIfNameMatches() {
        return Optional.ofNullable(this.ignoreTagsIfNameMatches);
    }

    public void setUntaggedName(String untaggedName) {
        this.untaggedName = untaggedName;
    }

    public String getTemplatePath() {
        return Optional.ofNullable(this.templatePath).orElse("changelog.mustache");
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getTemplateBaseDir() {
        return this.templateBaseDir;
    }

    public void setTemplateBaseDir(String templateBaseDir) {
        this.templateBaseDir = templateBaseDir;
    }

    public String getTemplateSuffix() {
        return this.templateSuffix;
    }

    public void setTemplateSuffix(String templateSuffix) {
        this.templateSuffix = templateSuffix;
    }

    public String getReadableTagName() {
        return Optional.ofNullable(this.readableTagName).orElse("/([^/]+?)$");
    }

    public String getDateFormat() {
        return Optional.ofNullable(this.dateFormat).orElse("yyyy-MM-dd HH:mm:ss");
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNoIssueName(String noIssueName) {
        this.noIssueName = noIssueName;
    }

    public void setReadableTagName(String readableTagName) {
        this.readableTagName = readableTagName;
    }

    public String getNoIssueName() {
        return Optional.ofNullable(this.noIssueName).orElse("No issue");
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return Optional.ofNullable(this.timeZone).orElse("UTC");
    }

    public static Settings defaultSettings() {
        Settings s = new Settings();
        s.setFromRepo(".");
        s.setFromRevision("0000000000000000000000000000000000000000");
        s.setFromRevisionStrategy(InclusivenessStrategy.DEFAULT);
        s.setToRevision("refs/heads/master");
        s.setToRevisionStrategy(InclusivenessStrategy.DEFAULT);
        s.setIgnoreCommitsIfMessageMatches("^Merge.*");
        s.setTemplateSuffix(".hbs");
        s.setReadableTagName("/([^/]+?)$");
        s.setDateFormat("YYYY-MM-dd HH:mm:ss");
        s.setUntaggedName("No tag");
        s.setNoIssueName("No issue");
        s.setTimeZone("UTC");
        s.setRemoveIssueFromMessage(true);
        s.setJiraIssuePattern("\\\\b[a-zA-Z]([a-zA-Z]+)-([0-9]+)\\\\b");
        return s;
    }

    public void setRemoveIssueFromMessage(boolean removeIssueFromMessage) {
        this.removeIssueFromMessage = removeIssueFromMessage;
    }

    public Boolean removeIssueFromMessage() {
        return Optional.ofNullable(this.removeIssueFromMessage).orElse(false);
    }

    public Optional<String> getGitHubApi() {
        return Optional.ofNullable(this.gitHubApi);
    }

    public Optional<String> getGitHubToken() {
        return Optional.ofNullable(this.gitHubToken);
    }

    public void setGitHubApi(String gitHubApi) {
        this.gitHubApi = gitHubApi;
    }

    public void setGitHubToken(String gitHubToken) {
        this.gitHubToken = gitHubToken;
    }

    public void setGitHubIssuePattern(String gitHubIssuePattern) {
        this.gitHubIssuePattern = gitHubIssuePattern;
    }

    public String getGitHubIssuePattern() {
        return Optional.ofNullable(this.gitHubIssuePattern).orElse("#([0-9]+)");
    }

    public Optional<String> getJiraUsername() {
        return Optional.ofNullable(this.jiraUsername);
    }

    public void setJiraPassword(String jiraPassword) {
        this.jiraPassword = jiraPassword;
    }

    public void setJiraToken(String jiraToken) {
        this.jiraToken = jiraToken;
    }

    public void setJiraBearer(String jiraBearer) {
        this.jiraBearer = jiraBearer;
    }

    public void setJiraUsername(String jiraUsername) {
        this.jiraUsername = jiraUsername;
    }

    public Optional<String> getJiraPassword() {
        return Optional.ofNullable(this.jiraPassword);
    }

    public Optional<String> getJiraToken() {
        return Optional.ofNullable(this.jiraToken);
    }

    public Optional<String> getJiraBearer() {
        return Optional.ofNullable(this.jiraBearer);
    }

    public Optional<String> getRedmineUsername() {
        return Optional.ofNullable(this.redmineUsername);
    }

    public void setRedminePassword(String redminePassword) {
        this.redminePassword = redminePassword;
    }

    public void setRedmineToken(String redmineToken) {
        this.redmineToken = redmineToken;
    }

    public void setRedmineUsername(String redmineUsername) {
        this.redmineUsername = redmineUsername;
    }

    public Optional<String> getRedminePassword() {
        return Optional.ofNullable(this.redminePassword);
    }

    public Optional<String> getRedmineToken() {
        return Optional.ofNullable(this.redmineToken);
    }

    public void setExtendedVariables(Map<String, Object> extendedVariables) {
        this.extendedVariables = extendedVariables;
    }

    public Map<String, Object> getExtendedVariables() {
        return this.extendedVariables;
    }

    public Map<String, String> getExtendedRestHeaders() {
        return this.extendedRestHeaders;
    }

    public void setExtendedRestHeaders(Map<String, String> extendedRestHeaders) {
        this.extendedRestHeaders = extendedRestHeaders;
    }

    public void setIgnoreCommitsWithoutIssue(boolean ignoreCommitsWithoutIssue) {
        this.ignoreCommitsWithoutIssue = ignoreCommitsWithoutIssue;
    }

    public boolean ignoreCommitsWithoutIssue() {
        return this.ignoreCommitsWithoutIssue;
    }

    public void setGitLabIssuePattern(String gitLabIssuePattern) {
        this.gitLabIssuePattern = gitLabIssuePattern;
    }

    public void setGitLabProjectName(String gitLabProjectName) {
        this.gitLabProjectName = gitLabProjectName;
    }

    public void setGitLabServer(String gitLabServer) {
        this.gitLabServer = gitLabServer;
    }

    public void setGitLabToken(String gitLabToken) {
        this.gitLabToken = gitLabToken;
    }

    public Optional<String> getGitLabServer() {
        return Optional.ofNullable(this.gitLabServer);
    }

    public Optional<String> getGitLabToken() {
        return Optional.ofNullable(this.gitLabToken);
    }

    public String getGitLabIssuePattern() {
        return Optional.ofNullable(this.gitLabIssuePattern).orElse("#([0-9]+)");
    }

    public Optional<String> getGitLabProjectName() {
        return Optional.ofNullable(this.gitLabProjectName);
    }

    public Optional<String> getSemanticMajorPattern() {
        return Optional.ofNullable(this.semanticMajorPattern);
    }

    public void setSemanticMajorPattern(String semanticMajorPattern) {
        this.semanticMajorPattern = this.isRegexp(semanticMajorPattern, "semanticMajorPattern");
    }

    public String getSemanticMinorPattern() {
        return Optional.ofNullable(this.semanticMinorPattern).orElse("^[Ff]eat.*");
    }

    public void setSemanticMinorPattern(String semanticMinorPattern) {
        this.semanticMinorPattern = this.isRegexp(semanticMinorPattern, "semanticMinorPattern");
    }

    public String getSemanticPatchPattern() {
        return Optional.ofNullable(this.semanticPatchPattern).orElse(GitChangelogApiConstants.DEFAULT_PATCH_PATTERN);
    }

    public void setSemanticPatchPattern(String semanticPatchPattern) {
        this.semanticPatchPattern = this.isRegexp(semanticPatchPattern, "semanticPatchPattern");
    }

    private String isRegexp(String pattern, String string) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException(pattern + " in " + string + " is not valid regexp.", e);
        }
        return pattern;
    }

    public void setGitHubEnabled(boolean githubEnabled) {
        this.gitHubEnabled = githubEnabled;
    }

    public void setGitLabEnabled(boolean gitlabEnabled) {
        this.gitLabEnabled = gitlabEnabled;
    }

    public void setJiraEnabled(boolean jiraEnabled) {
        this.jiraEnabled = jiraEnabled;
    }

    public void setRedmineEnabled(boolean redmineEnabled) {
        this.redmineEnabled = redmineEnabled;
    }

    public boolean isGitHubEnabled() {
        return this.gitHubEnabled;
    }

    public boolean isGitLabEnabled() {
        return this.gitLabEnabled;
    }

    public boolean isJiraEnabled() {
        return this.jiraEnabled;
    }

    public boolean isRedmineEnabled() {
        return this.redmineEnabled;
    }

    public void setUseIntegrations(boolean useIntegrations) {
        this.useIntegrations = useIntegrations;
    }

    public boolean isUseIntegrations() {
        return this.useIntegrations;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding.name();
    }

    public Charset getEncoding() {
        return Charset.forName(this.encoding);
    }

    public void setPathFilters(List<String> pathFilters) {
        this.pathFilters = pathFilters;
    }

    public List<String> getPathFilters() {
        return Optional.ofNullable(this.pathFilters).orElse(new ArrayList());
    }

    public List<String> getJiraIssueAdditionalFields() {
        if (this.jiraIssueAdditionalFields == null) {
            return new ArrayList<String>();
        }
        return this.jiraIssueAdditionalFields;
    }

    public void setJiraIssueAdditionalFields(List<String> jiraIssueAdditionalFields) {
        this.jiraIssueAdditionalFields = jiraIssueAdditionalFields;
    }

    public void addJiraIssueAdditionalField(String jiraIssueAdditionalField) {
        if (this.jiraIssueAdditionalFields == null) {
            this.jiraIssueAdditionalFields = new ArrayList<String>();
        }
        this.jiraIssueAdditionalFields.add(jiraIssueAdditionalField);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customIssues, this.dateFormat, this.encoding, this.extendedRestHeaders, this.extendedVariables, this.fromRepo, this.fromRevision, this.fromRevisionStrategy, this.gitHubApi, this.gitHubEnabled, this.gitHubIssuePattern, this.gitHubToken, this.gitLabEnabled, this.gitLabIssuePattern, this.gitLabProjectName, this.gitLabServer, this.gitLabToken, this.ignoreCommitsIfMessageMatches, this.ignoreCommitsIfOlderThan, this.ignoreCommitsWithoutIssue, this.ignoreTagsIfNameMatches, this.jiraBearer, this.jiraEnabled, this.jiraIssueAdditionalFields, this.jiraIssuePattern, this.jiraPassword, this.jiraServer, this.jiraToken, this.jiraUsername, this.noIssueName, this.readableTagName, this.redmineEnabled, this.redmineIssuePattern, this.redminePassword, this.redmineServer, this.redmineToken, this.redmineUsername, this.removeIssueFromMessage, this.semanticMajorPattern, this.semanticMinorPattern, this.semanticPatchPattern, this.pathFilters, this.templateBaseDir, this.templatePath, this.templateSuffix, this.timeZone, this.toRevision, this.toRevisionStrategy, this.untaggedName, this.useIntegrations});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Settings other = (Settings)obj;
        return Objects.equals(this.customIssues, other.customIssues) && Objects.equals(this.dateFormat, other.dateFormat) && Objects.equals(this.encoding, other.encoding) && Objects.equals(this.extendedRestHeaders, other.extendedRestHeaders) && Objects.equals(this.extendedVariables, other.extendedVariables) && Objects.equals(this.fromRepo, other.fromRepo) && Objects.equals(this.fromRevision, other.fromRevision) && this.fromRevisionStrategy == other.fromRevisionStrategy && Objects.equals(this.gitHubApi, other.gitHubApi) && this.gitHubEnabled == other.gitHubEnabled && Objects.equals(this.gitHubIssuePattern, other.gitHubIssuePattern) && Objects.equals(this.gitHubToken, other.gitHubToken) && this.gitLabEnabled == other.gitLabEnabled && Objects.equals(this.gitLabIssuePattern, other.gitLabIssuePattern) && Objects.equals(this.gitLabProjectName, other.gitLabProjectName) && Objects.equals(this.gitLabServer, other.gitLabServer) && Objects.equals(this.gitLabToken, other.gitLabToken) && Objects.equals(this.ignoreCommitsIfMessageMatches, other.ignoreCommitsIfMessageMatches) && Objects.equals(this.ignoreCommitsIfOlderThan, other.ignoreCommitsIfOlderThan) && this.ignoreCommitsWithoutIssue == other.ignoreCommitsWithoutIssue && Objects.equals(this.ignoreTagsIfNameMatches, other.ignoreTagsIfNameMatches) && Objects.equals(this.jiraBearer, other.jiraBearer) && this.jiraEnabled == other.jiraEnabled && Objects.equals(this.jiraIssueAdditionalFields, other.jiraIssueAdditionalFields) && Objects.equals(this.jiraIssuePattern, other.jiraIssuePattern) && Objects.equals(this.jiraPassword, other.jiraPassword) && Objects.equals(this.jiraServer, other.jiraServer) && Objects.equals(this.jiraToken, other.jiraToken) && Objects.equals(this.jiraUsername, other.jiraUsername) && Objects.equals(this.noIssueName, other.noIssueName) && Objects.equals(this.readableTagName, other.readableTagName) && this.redmineEnabled == other.redmineEnabled && Objects.equals(this.redmineIssuePattern, other.redmineIssuePattern) && Objects.equals(this.redminePassword, other.redminePassword) && Objects.equals(this.redmineServer, other.redmineServer) && Objects.equals(this.redmineToken, other.redmineToken) && Objects.equals(this.redmineUsername, other.redmineUsername) && this.removeIssueFromMessage == other.removeIssueFromMessage && Objects.equals(this.semanticMajorPattern, other.semanticMajorPattern) && Objects.equals(this.semanticMinorPattern, other.semanticMinorPattern) && Objects.equals(this.semanticPatchPattern, other.semanticPatchPattern) && Objects.equals(this.pathFilters, other.pathFilters) && Objects.equals(this.templateBaseDir, other.templateBaseDir) && Objects.equals(this.templatePath, other.templatePath) && Objects.equals(this.templateSuffix, other.templateSuffix) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.toRevision, other.toRevision) && this.toRevisionStrategy == other.toRevisionStrategy && Objects.equals(this.untaggedName, other.untaggedName) && this.useIntegrations == other.useIntegrations;
    }

    public String toString() {
        return "Settings [fromRepo=" + this.fromRepo + ", fromRevision=" + this.fromRevision + ", fromRevisionStrategy=" + this.fromRevisionStrategy + ", toRevision=" + this.toRevision + ", toRevisionStrategy=" + this.toRevisionStrategy + ", ignoreTagsIfNameMatches=" + this.ignoreTagsIfNameMatches + ", ignoreCommitsIfMessageMatches=" + this.ignoreCommitsIfMessageMatches + ", ignoreCommitsIfOlderThan=" + this.ignoreCommitsIfOlderThan + ", untaggedName=" + this.untaggedName + ", templatePath=" + this.templatePath + ", templateBaseDir=" + this.templateBaseDir + ", templateSuffix=" + this.templateSuffix + ", readableTagName=" + this.readableTagName + ", dateFormat=" + this.dateFormat + ", noIssueName=" + this.noIssueName + ", timeZone=" + this.timeZone + ", removeIssueFromMessage=" + this.removeIssueFromMessage + ", jiraEnabled=" + this.jiraEnabled + ", jiraServer=" + this.jiraServer + ", jiraIssuePattern=" + this.jiraIssuePattern + ", jiraIssueAdditionalFields=" + this.jiraIssueAdditionalFields + ", jiraUsername=" + this.jiraUsername + ", jiraPassword=" + this.jiraPassword + ", jiraToken=" + this.jiraToken + ", jiraBearer=" + this.jiraBearer + ", redmineEnabled=" + this.redmineEnabled + ", redmineServer=" + this.redmineServer + ", redmineIssuePattern=" + this.redmineIssuePattern + ", redmineUsername=" + this.redmineUsername + ", redminePassword=" + this.redminePassword + ", redmineToken=" + this.redmineToken + ", gitHubEnabled=" + this.gitHubEnabled + ", gitHubApi=" + this.gitHubApi + ", gitHubToken=" + this.gitHubToken + ", gitHubIssuePattern=" + this.gitHubIssuePattern + ", customIssues=" + this.customIssues + ", extendedVariables=" + this.extendedVariables + ", extendedRestHeaders=" + this.extendedRestHeaders + ", ignoreCommitsWithoutIssue=" + this.ignoreCommitsWithoutIssue + ", gitLabEnabled=" + this.gitLabEnabled + ", gitLabServer=" + this.gitLabServer + ", gitLabToken=" + this.gitLabToken + ", gitLabIssuePattern=" + this.gitLabIssuePattern + ", gitLabProjectName=" + this.gitLabProjectName + ", semanticMajorPattern=" + this.semanticMajorPattern + ", semanticMinorPattern=" + this.semanticMinorPattern + ", semanticPatchPattern=" + this.semanticPatchPattern + ", useIntegrations=" + this.useIntegrations + ", pathFilters=" + this.pathFilters + ", encoding=" + this.encoding + "]";
    }
}

