/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.git;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;

public class GitRepoData {
    private final List<GitCommit> gitCommits;
    private final List<GitTag> gitTags;
    private final String originCloneUrl;

    public GitRepoData(String originCloneUrl, List<GitTag> gitTags) {
        TreeSet<GitCommit> gitCommitsSorted = new TreeSet<GitCommit>();
        for (GitTag gitTag : gitTags) {
            gitCommitsSorted.addAll(gitTag.getGitCommits());
        }
        this.originCloneUrl = originCloneUrl;
        this.gitCommits = new ArrayList<GitCommit>(gitCommitsSorted);
        this.gitTags = gitTags;
    }

    public String getOriginCloneUrl() {
        return this.originCloneUrl;
    }

    public List<GitCommit> getGitCommits() {
        return this.gitCommits;
    }

    public List<GitTag> getGitTags() {
        return this.gitTags;
    }

    public Optional<String> findGitHubApi() {
        if (this.originCloneUrl == null) {
            return Optional.empty();
        }
        if (!this.originCloneUrl.contains("github.com")) {
            return Optional.empty();
        }
        return Optional.of("https://api.github.com/repos/" + (String)this.findOwnerName().orElse(null) + "/" + (String)this.findRepoName().orElse(null));
    }

    public Optional<String> findGitLabServer() {
        if (this.originCloneUrl == null) {
            return Optional.empty();
        }
        if (!this.originCloneUrl.contains("gitlab.com")) {
            return Optional.empty();
        }
        return Optional.of("https://gitlab.com/");
    }

    public Optional<String> findOwnerName() {
        return this.repoUrlPartFromEnd(1);
    }

    public Optional<String> findRepoName() {
        return this.repoUrlPartFromEnd(0);
    }

    private Optional<String> repoUrlPartFromEnd(int i) {
        List<String> partsList = this.getUrlPartsList();
        if (partsList.size() > i) {
            return Optional.of(partsList.get(i));
        }
        return Optional.empty();
    }

    public List<String> getUrlPartsList() {
        if (this.originCloneUrl == null) {
            return new ArrayList<String>();
        }
        String sequence = this.originCloneUrl.replaceAll("\\.git$", "");
        String pattern = "[/:]";
        String[] parts = sequence.split("[/:]");
        List<String> list = Arrays.asList(parts);
        Collections.reverse(list);
        return list;
    }
}

