/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.issues;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubHelper;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubIssue;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubLabel;
import se.bjurr.gitchangelog.internal.integrations.github.GitHubServiceFactory;
import se.bjurr.gitchangelog.internal.integrations.gitlab.GitLabClient;
import se.bjurr.gitchangelog.internal.integrations.gitlab.GitLabIssue;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraClient;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraClientFactory;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraIssue;
import se.bjurr.gitchangelog.internal.integrations.redmine.RedmineClient;
import se.bjurr.gitchangelog.internal.integrations.redmine.RedmineClientFactory;
import se.bjurr.gitchangelog.internal.integrations.redmine.RedmineIssue;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.settings.IssuesUtil;
import se.bjurr.gitchangelog.internal.settings.Settings;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;

@SuppressFBWarnings(value={"CRLF_INJECTION_LOGS"})
public class IssueParser {
    private static final Logger LOG = LoggerFactory.getLogger(IssueParser.class);
    private final List<GitCommit> commits;
    private final Settings settings;

    public IssueParser(Settings settings, List<GitCommit> commits) {
        this.settings = settings;
        this.commits = commits;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public List<GitCommit> getCommits() {
        return this.commits;
    }

    public List<ParsedIssue> parseForIssues(boolean useIntegrations) {
        HashMap<String, ParsedIssue> parsedIssuePerIssue = new HashMap<String, ParsedIssue>();
        GitHubHelper gitHubHelper = useIntegrations ? this.createGitHubClient() : null;
        JiraClient jiraClient = useIntegrations ? this.createJiraClient() : null;
        RedmineClient redmineClient = useIntegrations ? this.createRedmineClient() : null;
        GitLabClient gitLabClient = useIntegrations ? this.createGitLabClient() : null;
        List<SettingsIssue> patterns = new IssuesUtil(this.settings).getIssues();
        for (GitCommit gitCommit : this.commits) {
            boolean commitMappedToAtLeastOneIssue = false;
            for (SettingsIssue issuePattern : patterns) {
                Matcher issueMatcher = Pattern.compile(issuePattern.getPattern()).matcher(gitCommit.getMessage());
                while (issueMatcher.find()) {
                    String matchedIssue = issueMatcher.group();
                    if (matchedIssue.isEmpty()) continue;
                    if (!parsedIssuePerIssue.containsKey(matchedIssue)) {
                        ParsedIssue parsedIssue;
                        if (issuePattern.getType() == SettingsIssueType.GITHUB) {
                            parsedIssue = this.createParsedIssue(gitHubHelper, issuePattern, matchedIssue);
                        } else if (issuePattern.getType() == SettingsIssueType.GITLAB) {
                            String projectName = this.settings.getGitLabProjectName().get();
                            parsedIssue = this.createParsedIssue(gitLabClient, projectName, issuePattern, matchedIssue);
                        } else {
                            parsedIssue = issuePattern.getType() == SettingsIssueType.JIRA ? this.createParsedIssue(jiraClient, issuePattern, matchedIssue) : (issuePattern.getType() == SettingsIssueType.REDMINE ? this.createParsedIssue(redmineClient, issuePattern, matchedIssue) : this.createParsedIssue(issuePattern, issueMatcher, matchedIssue));
                        }
                        parsedIssuePerIssue.put(matchedIssue, parsedIssue);
                    }
                    if (!((ParsedIssue)parsedIssuePerIssue.get(matchedIssue)).getGitCommits().contains(gitCommit)) {
                        ((ParsedIssue)parsedIssuePerIssue.get(matchedIssue)).getGitCommits().add(gitCommit);
                    }
                    commitMappedToAtLeastOneIssue = true;
                }
            }
            if (commitMappedToAtLeastOneIssue || this.settings.ignoreCommitsWithoutIssue()) continue;
            String issue = null;
            String link = null;
            String title = null;
            String issueType = null;
            List<String> linkedIssues = null;
            List<String> labels = null;
            TreeMap<String, Object> additionalFields = new TreeMap<String, Object>();
            ParsedIssue noIssue = new ParsedIssue(SettingsIssueType.NOISSUE, this.settings.getNoIssueName(), issue, "", link, title, issueType, linkedIssues, labels, additionalFields);
            if (!parsedIssuePerIssue.containsKey(noIssue.getName())) {
                parsedIssuePerIssue.put(noIssue.getName(), noIssue);
            }
            ((ParsedIssue)parsedIssuePerIssue.get(noIssue.getName())).addCommit(gitCommit);
        }
        return parsedIssuePerIssue.values().stream().sorted((a, b) -> a.toString().compareTo(b.toString())).collect(Collectors.toList());
    }

    private ParsedIssue createParsedIssue(GitLabClient gitLabClient, String projectName, SettingsIssue issuePattern, String matchedIssueString) {
        String link = "";
        String title = "";
        ArrayList<String> linkedIssues = new ArrayList<String>();
        List<String> labels = new ArrayList<String>();
        TreeMap<String, Object> additionalFields = new TreeMap<String, Object>();
        if (matchedIssueString.startsWith("#")) {
            matchedIssueString = matchedIssueString.substring(1);
        }
        Integer matchedIssue = Integer.parseInt(matchedIssueString);
        try {
            if (gitLabClient != null && gitLabClient.getIssue(projectName, matchedIssue).isPresent()) {
                GitLabIssue gitLabIssue = gitLabClient.getIssue(projectName, matchedIssue).get();
                link = gitLabIssue.getLink();
                title = gitLabIssue.getTitle();
                labels = gitLabIssue.getLabels();
            }
        }
        catch (GitChangelogIntegrationException e) {
            LOG.error(matchedIssueString, (Throwable)e);
        }
        String issueType = null;
        return new ParsedIssue(SettingsIssueType.GITLAB, issuePattern.getName(), matchedIssueString, "", link, title, issueType, linkedIssues, labels, additionalFields);
    }

    private GitLabClient createGitLabClient() {
        GitLabClient client = null;
        if (this.settings.getGitLabServer().isPresent()) {
            String server = this.settings.getGitLabServer().get();
            String token = this.settings.getGitLabToken().orElse(null);
            client = new GitLabClient(server, token);
        }
        return client;
    }

    private JiraClient createJiraClient() {
        JiraClient jiraClient = null;
        if (this.settings.getJiraServer().isPresent()) {
            jiraClient = JiraClientFactory.createJiraClient(this.settings.getJiraServer().get());
            if (this.settings.getJiraUsername().isPresent()) {
                jiraClient.withBasicCredentials(this.settings.getJiraUsername().get(), this.settings.getJiraPassword().get());
            } else if (this.settings.getJiraToken().isPresent()) {
                jiraClient.withTokenCredentials(this.settings.getJiraToken().get());
            } else if (this.settings.getJiraBearer().isPresent()) {
                jiraClient.withBearer(this.settings.getJiraBearer().get());
            }
            if (this.settings.getExtendedRestHeaders() != null) {
                jiraClient.withHeaders(this.settings.getExtendedRestHeaders());
            }
            if (!this.settings.getJiraIssueAdditionalFields().isEmpty()) {
                jiraClient.withIssueAdditionalFields(this.settings.getJiraIssueAdditionalFields());
            }
        }
        return jiraClient;
    }

    private RedmineClient createRedmineClient() {
        RedmineClient redmineClient = null;
        if (this.settings.getRedmineServer().isPresent()) {
            redmineClient = RedmineClientFactory.createRedmineClient(this.settings.getRedmineServer().get());
            if (this.settings.getRedmineUsername().isPresent()) {
                redmineClient.withBasicCredentials(this.settings.getRedmineUsername().get(), this.settings.getRedminePassword().get());
            } else if (this.settings.getRedmineToken().isPresent()) {
                redmineClient.withTokenCredentials(this.settings.getRedmineToken().get());
            }
            if (this.settings.getExtendedRestHeaders() != null) {
                redmineClient.withHeaders(this.settings.getExtendedRestHeaders());
            }
        }
        return redmineClient;
    }

    private GitHubHelper createGitHubClient() {
        if (this.settings.getGitHubApi().isPresent()) {
            return new GitHubHelper(GitHubServiceFactory.getGitHubService(this.settings.getGitHubApi().get(), this.settings.getGitHubToken()));
        }
        return null;
    }

    private ParsedIssue createParsedIssue(SettingsIssue issuePattern, Matcher issueMatcher, String matchedIssue) {
        String link = this.render(issuePattern.getLink().orElse(""), issueMatcher, matchedIssue);
        String title = this.render(issuePattern.getTitle().orElse(""), issueMatcher, matchedIssue);
        String issueType = null;
        List<String> linkedIssues = null;
        List<String> labels = null;
        TreeMap<String, Object> additionalFields = new TreeMap<String, Object>();
        return new ParsedIssue(SettingsIssueType.CUSTOM, issuePattern.getName(), matchedIssue, "", link, title, issueType, linkedIssues, labels, additionalFields);
    }

    private ParsedIssue createParsedIssue(JiraClient jiraClient, SettingsIssue issuePattern, String matchedIssue) {
        String link = "";
        String title = "";
        String desc = "";
        String issueType = null;
        List<String> linkedIssues = null;
        List<String> labels = null;
        Map<String, Object> additionalFields = null;
        try {
            if (jiraClient != null && jiraClient.getIssue(matchedIssue).isPresent()) {
                JiraIssue jiraIssue = jiraClient.getIssue(matchedIssue).get();
                link = jiraIssue.getLink();
                title = jiraIssue.getTitle();
                issueType = jiraIssue.getIssueType();
                linkedIssues = jiraIssue.getLinkedIssues();
                labels = jiraIssue.getLabels();
                desc = jiraIssue.getDescription();
                additionalFields = jiraIssue.getAdditionalFields();
            }
        }
        catch (GitChangelogIntegrationException e) {
            LOG.error(matchedIssue, (Throwable)e);
        }
        return new ParsedIssue(SettingsIssueType.JIRA, issuePattern.getName(), matchedIssue, desc, link, title, issueType, linkedIssues, labels, additionalFields);
    }

    private ParsedIssue createParsedIssue(RedmineClient redmineClient, SettingsIssue issuePattern, String matchedIssue) {
        String link = "";
        String title = "";
        String desc = "";
        String issueType = null;
        List<String> linkedIssues = null;
        List<String> labels = null;
        TreeMap<String, Object> additionalFields = new TreeMap<String, Object>();
        try {
            if (redmineClient != null && redmineClient.getIssue(matchedIssue).isPresent()) {
                RedmineIssue redmineIssue = redmineClient.getIssue(matchedIssue).get();
                link = redmineIssue.getLink();
                title = redmineIssue.getTitle();
                issueType = redmineIssue.getIssueType();
                desc = redmineIssue.getDescription();
            }
        }
        catch (GitChangelogIntegrationException e) {
            LOG.error(matchedIssue, (Throwable)e);
        }
        return new ParsedIssue(SettingsIssueType.REDMINE, issuePattern.getName(), matchedIssue, desc, link, title, issueType, linkedIssues, labels, additionalFields);
    }

    private ParsedIssue createParsedIssue(GitHubHelper gitHubHelper, SettingsIssue issuePattern, String matchedIssue) {
        String link = "";
        String title = "";
        ArrayList<String> linkedIssues = new ArrayList<String>();
        ArrayList<String> labels = new ArrayList<String>();
        TreeMap<String, Object> additionalFields = new TreeMap<String, Object>();
        try {
            Optional<GitHubIssue> issues;
            if (gitHubHelper != null && (issues = gitHubHelper.getIssueFromAll(matchedIssue)).isPresent()) {
                GitHubIssue gitHubIssue = issues.get();
                link = gitHubIssue.getLink();
                title = gitHubIssue.getTitle();
                for (GitHubLabel label : gitHubIssue.getLabels()) {
                    labels.add(label.getName());
                }
            }
        }
        catch (GitChangelogIntegrationException e) {
            LOG.error(matchedIssue, (Throwable)e);
        }
        String issueType = null;
        return new ParsedIssue(SettingsIssueType.GITHUB, issuePattern.getName(), matchedIssue, "", link, title, issueType, linkedIssues, labels, additionalFields);
    }

    private String render(String string, Matcher matcher, String matched) {
        string = string.replaceAll("\\$\\{PATTERN_GROUP\\}", matched);
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            string = string.replaceAll("\\$\\{PATTERN_GROUP_" + i + "\\}", this.firstNonNull(matcher.group(i), ""));
        }
        return string;
    }

    private String firstNonNull(String a, String b) {
        if (a == null) {
            return b;
        }
        return a;
    }
}

