/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import se.bjurr.gitchangelog.api.model.Author;
import se.bjurr.gitchangelog.api.model.Commit;
import se.bjurr.gitchangelog.api.model.Issue;
import se.bjurr.gitchangelog.api.model.IssueType;
import se.bjurr.gitchangelog.api.model.Tag;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.git.model.GitTag;
import se.bjurr.gitchangelog.internal.model.ParsedIssue;
import se.bjurr.gitchangelog.internal.settings.IssuesUtil;
import se.bjurr.gitchangelog.internal.settings.Settings;
import se.bjurr.gitchangelog.internal.settings.SettingsIssue;

public class Transformer {
    public static final Pattern PATTERN_THIS_REVERTS = Pattern.compile("This reverts commit ([a-z0-9]+).", 8);
    private final Settings settings;

    public Transformer(Settings settings) {
        this.settings = settings;
    }

    public List<Author> toAuthors(List<GitCommit> gitCommits) {
        TreeMap authors = new TreeMap();
        ArrayList<String> keys = new ArrayList<String>();
        for (GitCommit gitCommit : gitCommits) {
            String key2 = this.getKey(gitCommit.getAuthorName(), gitCommit.getAuthorEmailAddress());
            if (!authors.containsKey(key2)) {
                authors.put(key2, new TreeSet());
                keys.add(key2);
            }
            ((Set)authors.get(key2)).add(gitCommit);
        }
        return keys.stream().map(key -> (Set)authors.get(key)).map(gc -> this.toCommits((Collection<GitCommit>)gc)).filter(it -> it.size() > 0).map(commits -> new Author(((Commit)commits.get(0)).getAuthorName(), ((Commit)commits.get(0)).getAuthorEmailAddress(), (List<Commit>)commits)).collect(Collectors.toList());
    }

    private String getKey(String authorName, String authorEmail) {
        return ("name:" + authorName + "-email:" + authorEmail).toLowerCase(Locale.ENGLISH);
    }

    private boolean isRevertCommit(GitCommit commit) {
        return this.getRevertCommitHash(commit) != null;
    }

    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"})
    private boolean isRevertedCommit(GitCommit commit, Iterable<GitCommit> revertCommits) {
        for (GitCommit revertCommit : revertCommits) {
            String revertedHash = this.getRevertCommitHash(revertCommit);
            if (!commit.getHash().equals(revertedHash)) continue;
            return true;
        }
        return false;
    }

    private String getRevertCommitHash(GitCommit revertCommit) {
        Matcher matcher = PATTERN_THIS_REVERTS.matcher(revertCommit.getMessage());
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }

    public List<Commit> toCommits(Collection<GitCommit> from) {
        List revertCommits = from.stream().filter(it -> this.isRevertCommit((GitCommit)it)).collect(Collectors.toList());
        List revertedCommits = from.stream().filter(it -> this.isRevertedCommit((GitCommit)it, revertCommits)).collect(Collectors.toList());
        List revertCommitsToRemove = revertedCommits.stream().map(it -> revertCommits.stream().filter(rc -> this.getRevertCommitHash((GitCommit)rc).equals(it.getHash())).findFirst().get()).collect(Collectors.toList());
        List fromWithoutReverted = from.stream().filter(it -> !revertedCommits.contains(it) && !revertCommitsToRemove.contains(it)).collect(Collectors.toList());
        List filteredCommits = fromWithoutReverted.stream().filter(gitCommit -> {
            boolean olderThan;
            boolean messageMatches = Pattern.compile(this.settings.getIgnoreCommitsIfMessageMatches(), 32).matcher(gitCommit.getMessage()).matches();
            if (messageMatches) {
                return false;
            }
            return !this.settings.getIgnoreCommitsIfOlderThan().isPresent() || !(olderThan = gitCommit.getCommitTime().before(this.settings.getIgnoreCommitsIfOlderThan().get()));
        }).collect(Collectors.toList());
        return filteredCommits.stream().map(c -> this.toCommit((GitCommit)c)).collect(Collectors.toList());
    }

    public List<Issue> toIssues(List<ParsedIssue> issues) {
        List<ParsedIssue> issuesWithCommits = this.filterWithCommits(issues);
        return issuesWithCommits.stream().map(it -> this.parsedIssueToIssue((ParsedIssue)it)).collect(Collectors.toList());
    }

    public List<IssueType> toIssueTypes(List<ParsedIssue> issues) {
        TreeMap issuesPerName = new TreeMap();
        for (ParsedIssue parsedIssue : this.filterWithCommits(issues)) {
            if (!issuesPerName.containsKey(parsedIssue.getName())) {
                issuesPerName.put(parsedIssue.getName(), new ArrayList());
            }
            Issue transformedIssues = this.parsedIssueToIssue(parsedIssue);
            ((List)issuesPerName.get(parsedIssue.getName())).add(transformedIssues);
        }
        ArrayList<IssueType> issueTypes = new ArrayList<IssueType>();
        for (Map.Entry entry : issuesPerName.entrySet()) {
            issueTypes.add(new IssueType((List)entry.getValue(), (String)entry.getKey()));
        }
        return issueTypes;
    }

    public List<Tag> toTags(List<GitTag> gitTags, List<ParsedIssue> allParsedIssues) {
        List tags = gitTags.stream().map(input -> {
            List<GitCommit> gitCommits = input.getGitCommits();
            List<ParsedIssue> parsedIssues = this.reduceParsedIssuesToOnlyGitCommits(allParsedIssues, gitCommits);
            List<Commit> commits = this.toCommits(gitCommits);
            List<Author> authors = this.toAuthors(gitCommits);
            List<Issue> issues = this.toIssues(parsedIssues);
            List<IssueType> issueTypes = this.toIssueTypes(parsedIssues);
            return new Tag(Transformer.toReadableTagName(input.getName(), this.settings.getReadableTagName()), input.findAnnotation().orElse(null), commits, authors, issues, issueTypes, input.getTagTime() != null ? this.format(input.getTagTime()) : "", input.getTagTime() != null ? input.getTagTime().getTime() : -1L);
        }).collect(Collectors.toList());
        return tags.stream().filter(input -> !input.getAuthors().isEmpty() && !input.getCommits().isEmpty()).collect(Collectors.toList());
    }

    private List<ParsedIssue> reduceParsedIssuesToOnlyGitCommits(List<ParsedIssue> allParsedIssues, List<GitCommit> gitCommits) {
        ArrayList<ParsedIssue> parsedIssues = new ArrayList<ParsedIssue>();
        for (ParsedIssue candidate : allParsedIssues) {
            List<GitCommit> candidateCommits = candidate.getGitCommits().stream().filter(it -> gitCommits.contains(it)).collect(Collectors.toList());
            if (candidateCommits.isEmpty()) continue;
            ParsedIssue parsedIssue = new ParsedIssue(candidate.getSettingsIssueType(), candidate.getName(), candidate.getIssue(), candidate.getDescription(), candidate.getLink(), candidate.getTitle().orElse(null), candidate.getIssueType(), candidate.getLinkedIssues(), candidate.getLabels(), candidate.getAdditionalFields());
            parsedIssue.addCommits(candidateCommits);
            parsedIssues.add(parsedIssue);
        }
        return parsedIssues;
    }

    private List<ParsedIssue> filterWithCommits(List<ParsedIssue> issues) {
        return issues.stream().filter(input -> !this.toCommits(input.getGitCommits()).isEmpty()).collect(Collectors.toList());
    }

    private String format(Date commitTime) {
        SimpleDateFormat df = new SimpleDateFormat(this.settings.getDateFormat(), Locale.ENGLISH);
        df.setTimeZone(TimeZone.getTimeZone(this.settings.getTimeZone()));
        return df.format(commitTime);
    }

    private Issue parsedIssueToIssue(ParsedIssue input) {
        List<GitCommit> gitCommits = input.getGitCommits();
        return new Issue(this.toCommits(gitCommits), this.toAuthors(gitCommits), input.getName(), input.getTitle().orElse(""), input.getIssue(), input.getSettingsIssueType(), input.getDescription(), input.getLink(), input.getIssueType(), input.getLinkedIssues(), input.getLabels(), input.getAdditionalFields());
    }

    private String removeIssuesFromString(boolean removeIssueFromMessage, List<SettingsIssue> issues, String string) {
        if (removeIssueFromMessage) {
            for (SettingsIssue issue : issues) {
                string = string.replaceAll(issue.getPattern(), "");
            }
        }
        return string;
    }

    private Commit toCommit(GitCommit gitCommit) {
        return new Commit(gitCommit.getAuthorName(), gitCommit.getAuthorEmailAddress(), this.format(gitCommit.getCommitTime()), gitCommit.getCommitTime().getTime(), this.toMessage(this.settings.removeIssueFromMessage(), new IssuesUtil(this.settings).getIssues(), gitCommit.getMessage()), gitCommit.getHash(), gitCommit.isMerge());
    }

    public static String toReadableTagName(String input, String readableTagName) {
        Matcher matcher = Pattern.compile(readableTagName).matcher(input);
        if (matcher.find()) {
            if (matcher.groupCount() == 0) {
                throw new RuntimeException("Pattern: \"" + readableTagName + "\" did not match any group in: \"" + input + "\"");
            }
            return matcher.group(1);
        }
        return input;
    }

    String toMessage(boolean removeIssueFromMessage, List<SettingsIssue> issues, String message) {
        return this.removeIssuesFromString(removeIssueFromMessage, issues, message);
    }
}

