/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.api.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.helper.EachHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import se.bjurr.gitchangelog.internal.semantic.ConventionalCommitParser;

public class Helpers {
    public static Map<String, Helper<?>> getAll() {
        TreeMap helpers = new TreeMap();
        helpers.put("ifEquals", (a, options) -> {
            Object b = options.params[0];
            boolean equality = a.equals(b);
            return Helpers.conditional(options, equality);
        });
        helpers.put("ifMatches", (a, options) -> {
            String regexp = (String)options.params[0];
            boolean equality = a.toString().matches(regexp);
            return Helpers.conditional(options, equality);
        });
        helpers.put("subString", (a, options) -> {
            Integer from = (Integer)options.params[0];
            if (options.params.length == 1) {
                return a.toString().substring(from);
            }
            Integer to = (Integer)options.params[1];
            return a.toString().substring(from, to);
        });
        helpers.put("ifReleaseTag", (tag, options) -> Helpers.conditional(options, ConventionalCommitParser.isReleaseTag(tag)));
        helpers.put("tagDate", (tag, options) -> ConventionalCommitParser.getDate(tag.getTagTime()));
        helpers.put("commitDate", (commit, options) -> ConventionalCommitParser.getDate(commit.getCommitTime()));
        helpers.put("ifContainsType", (commits, options) -> Helpers.conditional(options, ConventionalCommitParser.containsType(commits, options)));
        helpers.put("ifContainsScope", (commits, options) -> Helpers.conditional(options, ConventionalCommitParser.containsScope(commits, options)));
        helpers.put("ifContainsTypeAndScope", (commits, options) -> Helpers.conditional(options, ConventionalCommitParser.containsTypeAndScope(commits, options)));
        helpers.put("ifContainsTypeOtherThan", (commits, options) -> Helpers.conditional(options, ConventionalCommitParser.containsTypeOtherThan(commits, options)));
        helpers.put("ifContainsBreaking", (commits, options) -> Helpers.conditional(options, ConventionalCommitParser.containsBreaking(commits, options)));
        helpers.put("ifCommitType", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.commitType(commit.getMessage(), options)));
        helpers.put("ifCommitTypeOtherThan", (commit, options) -> Helpers.conditional(options, !ConventionalCommitParser.commitType(commit.getMessage(), options)));
        helpers.put("ifCommitBreaking", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.commitBreaking(commit.getMessage())));
        helpers.put("ifContainsIssueType", (issues, options) -> Helpers.conditional(options, ConventionalCommitParser.containsIssueType(issues, options)));
        helpers.put("ifContainsIssueTypeOtherThan", (issues, options) -> Helpers.conditional(options, ConventionalCommitParser.containsIssueTypeOtherThan(issues, options)));
        helpers.put("ifContainsIssueLabel", (issues, options) -> Helpers.conditional(options, ConventionalCommitParser.containsIssueLabel(issues, options)));
        helpers.put("ifContainsIssueLabelOtherThan", (issues, options) -> Helpers.conditional(options, ConventionalCommitParser.containsIssueLabelOtherThan(issues, options)));
        helpers.put("ifIssueType", (issue, options) -> Helpers.conditional(options, ConventionalCommitParser.issueType(issue.getType(), options)));
        helpers.put("ifIssueLabel", (issue, options) -> Helpers.conditional(options, ConventionalCommitParser.issueLabel(issue, options)));
        helpers.put("ifIssueTypeOtherThan", (issue, options) -> Helpers.conditional(options, !ConventionalCommitParser.issueType(issue.getType(), options)));
        helpers.put("ifCommitScope", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.commitScope(commit, options)));
        helpers.put("ifCommitHasFooters", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.getMessageParts((String)commit.getMessage()).footers.size() > 0));
        helpers.put("ifCommitHasParagraphs", (commit, options) -> Helpers.conditional(options, ConventionalCommitParser.getMessageParts((String)commit.getMessage()).paragraphs.size() > 0));
        helpers.put("eachCommitScope", (commit, options) -> Helpers.each(options, ConventionalCommitParser.commitScopes(commit.getMessage())));
        helpers.put("commitDescription", (commit, options) -> ConventionalCommitParser.commitDescription(commit.getMessage()));
        helpers.put("eachCommitRefs", (commit, options) -> Helpers.each(options, ConventionalCommitParser.commitRefs(commit.getMessage())));
        helpers.put("eachCommitFixes", (commit, options) -> Helpers.each(options, ConventionalCommitParser.commitFixes(commit.getMessage())));
        helpers.put("revertedCommit", (commit, options) -> ConventionalCommitParser.revertedCommit(commit.getMessage()));
        helpers.put("eachCommitParagraph", (commit, options) -> Helpers.each(options, ConventionalCommitParser.getMessageParts((String)commit.getMessage()).paragraphs));
        helpers.put("eachCommitFooter", (commit, options) -> {
            if (options.hash.containsKey("tokenMatching")) {
                String regex = (String)options.hash("tokenMatching");
                return Helpers.each(options, ConventionalCommitParser.getMessageParts((String)commit.getMessage()).footers.stream().filter(it -> it.token.matches(regex)).collect(Collectors.toList()));
            }
            return Helpers.each(options, ConventionalCommitParser.getMessageParts((String)commit.getMessage()).footers);
        });
        helpers.put("ifFooterHasValue", (footer, options) -> Helpers.conditional(options, !footer.value.trim().isEmpty()));
        helpers.put("eachUrlPart", (changelog, options) -> {
            ArrayList<String> reversedList = new ArrayList<String>(changelog.getUrlParts());
            Collections.reverse(reversedList);
            return Helpers.each(options, reversedList);
        });
        return helpers;
    }

    private static Object each(Options options, List<?> elements) throws IOException {
        return new EachHelper().apply(elements, options);
    }

    private static Options.Buffer conditional(Options options, boolean condition) throws IOException {
        Options.Buffer buffer = options.buffer();
        if (condition) {
            buffer.append(options.fn());
        } else {
            buffer.append(options.inverse());
        }
        return buffer;
    }
}

