/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.git;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

@SuppressFBWarnings(value={"CRLF_INJECTION_LOGS"})
class TraversalWork
implements Comparable<TraversalWork> {
    private final RevCommit to;
    private final String currentTagName;

    public TraversalWork(RevCommit to, String currentTagName) {
        this.to = to;
        this.currentTagName = currentTagName;
    }

    public String getCurrentTagName() {
        return this.currentTagName;
    }

    public RevCommit getTo() {
        return this.to;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TraversalWork other = (TraversalWork)obj;
        return !(this.to == null ? other.to != null : !this.to.equals((AnyObjectId)other.to));
    }

    @Override
    public int compareTo(TraversalWork o) {
        int otherCommitTime = o.getTo().getCommitTime();
        int compareTo = this.compareTo(this.to.getCommitTime(), otherCommitTime);
        if (compareTo == 0) {
            return this.to.getName().compareTo(o.getTo().getName());
        }
        return compareTo;
    }

    int compareTo(int y, int x) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public String toString() {
        return "TraversalWork [to=" + this.to + ", currentTagName=" + this.currentTagName + "]";
    }
}

