/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.rest;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;

@SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD", "CRLF_INJECTION_LOGS"})
public class RestClient {
    private static Logger logger = LoggerFactory.getLogger(RestClient.class);
    private static RestClient mockedRestClient;
    private final Map<String, Optional<String>> urlCache = new ConcurrentHashMap<String, Optional<String>>();
    private String basicAuthString;
    private String bearer;
    private Map<String, String> headers;

    public RestClient withBasicAuthCredentials(String username, String password) {
        try {
            this.basicAuthString = Base64.getEncoder().encodeToString((username + ":" + password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public RestClient withTokenAuthCredentials(String token) {
        this.basicAuthString = token;
        return this;
    }

    public RestClient withBearer(String bearer) {
        this.bearer = bearer;
        return this;
    }

    public RestClient withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Optional<String> get(String url) throws GitChangelogIntegrationException {
        try {
            if (!this.urlCache.containsKey(url)) {
                Optional<String> content = this.doGet(url);
                this.urlCache.put(url, content);
            }
            return this.urlCache.get(url);
        }
        catch (Exception e) {
            throw new GitChangelogIntegrationException("Problems invoking " + url, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> doGet(String urlParam) {
        String response = null;
        HttpURLConnection conn = null;
        try {
            logger.info("GET:\n" + urlParam);
            URL url = new URL(urlParam);
            conn = this.openConnection(url);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            if (this.headers != null) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (this.bearer != null) {
                conn.setRequestProperty("Authorization", "Bearer " + this.bearer);
            } else if (this.basicAuthString != null) {
                conn.setRequestProperty("Authorization", "Basic " + this.basicAuthString);
            }
            Optional<String> optional = Optional.of(this.getResponse(conn));
            return optional;
        }
        catch (Exception e) {
            logger.error("Got:\n" + response, (Throwable)e);
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected HttpURLConnection openConnection(URL url) throws Exception {
        if (mockedRestClient == null) {
            return (HttpURLConnection)url.openConnection();
        }
        return mockedRestClient.openConnection(url);
    }

    /*
     * Exception decompiling
     */
    protected String getResponse(HttpURLConnection conn) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void mock(RestClient mock) {
        mockedRestClient = mock;
    }
}

