/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.plugin;

import java.io.File;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import se.bjurr.gitchangelog.api.GitChangelogApi;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersion;
import se.bjurr.gitchangelog.plugin.XmlModifier;

@Mojo(name="semantic-version", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class SemanticVersionMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(property="updatePomWithNextSemanticVersionSuffixSnapshot", required=false, defaultValue="true")
    private boolean updatePomWithNextSemanticVersionSuffixSnapshot;
    @Parameter(property="semanticMajorVersionPattern", required=false)
    private String semanticMajorVersionPattern;
    @Parameter(property="semanticMinorVersionPattern", required=false)
    private String semanticMinorVersionPattern;
    @Parameter(property="semanticPatchVersionPattern", required=false)
    private String semanticPatchVersionPattern;
    @Parameter(property="ignoreTagsIfNameMatches", required=false)
    private String ignoreTagsIfNameMatches;

    public void execute() throws MojoExecutionException {
        try {
            GitChangelogApi gitChangelogApiBuilder = GitChangelogApi.gitChangelogApiBuilder();
            if (this.isSupplied(this.semanticMajorVersionPattern)) {
                gitChangelogApiBuilder.withSemanticMajorVersionPattern(this.semanticMajorVersionPattern);
            }
            if (this.isSupplied(this.semanticMinorVersionPattern)) {
                gitChangelogApiBuilder.withSemanticMinorVersionPattern(this.semanticMinorVersionPattern);
            }
            if (this.isSupplied(this.semanticPatchVersionPattern)) {
                gitChangelogApiBuilder.withSemanticPatchVersionPattern(this.semanticPatchVersionPattern);
            }
            if (this.isSupplied(this.ignoreTagsIfNameMatches)) {
                gitChangelogApiBuilder.withIgnoreTagsIfNameMatches(this.ignoreTagsIfNameMatches);
            }
            SemanticVersion nextSemanticVersion = gitChangelogApiBuilder.getNextSemanticVersion();
            String nextVersion = this.updatePomWithNextSemanticVersionSuffixSnapshot ? nextSemanticVersion.getVersion() + "-SNAPSHOT" : nextSemanticVersion.getVersion();
            Model model = this.project.getModel();
            String versionOrig = model.getVersion();
            File pomFile = this.project.getFile();
            this.getLog().info((CharSequence)("Setting version to " + nextVersion + " was (" + versionOrig + ") in " + pomFile));
            model.setVersion(nextVersion);
            new XmlModifier(pomFile).setVersion(nextVersion);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean isSupplied(String param) {
        return param != null && !param.isEmpty();
    }
}

