/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.plugin;

import java.io.File;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import se.bjurr.gitchangelog.api.GitChangelogApi;
import se.bjurr.gitchangelog.internal.semantic.SemanticVersion;
import se.bjurr.gitchangelog.plugin.XmlModifier;

@Mojo(name="semantic-version", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class SemanticVersionMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(property="skip", required=false)
    private Boolean skip;
    @Parameter(property="updatePomWithCurrentSemanticVersionSuffixSnapshot", required=false, defaultValue="false")
    private boolean updatePomWithCurrentSemanticVersionSuffixSnapshot;
    @Parameter(property="updatePomWithCurrentSemanticVersionSuffixSnapshotIfNotTagged", required=false, defaultValue="true")
    private boolean updatePomWithCurrentSemanticVersionSuffixSnapshotIfNotTagged;
    @Parameter(property="semanticMajorVersionPattern", required=false)
    private String semanticMajorVersionPattern;
    @Parameter(property="semanticMinorVersionPattern", required=false)
    private String semanticMinorVersionPattern;
    @Parameter(property="semanticPatchVersionPattern", required=false)
    private String semanticPatchVersionPattern;
    @Parameter(property="ignoreTagsIfNameMatches", required=false)
    private String ignoreTagsIfNameMatches;

    public void execute() throws MojoExecutionException {
        if (this.skip != null && this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping semantic version");
            return;
        }
        try {
            GitChangelogApi gitChangelogApiBuilder = GitChangelogApi.gitChangelogApiBuilder();
            if (this.isSupplied(this.semanticMajorVersionPattern)) {
                gitChangelogApiBuilder.withSemanticMajorVersionPattern(this.semanticMajorVersionPattern);
            }
            if (this.isSupplied(this.semanticMinorVersionPattern)) {
                gitChangelogApiBuilder.withSemanticMinorVersionPattern(this.semanticMinorVersionPattern);
            }
            if (this.isSupplied(this.semanticPatchVersionPattern)) {
                gitChangelogApiBuilder.withSemanticPatchVersionPattern(this.semanticPatchVersionPattern);
            }
            if (this.isSupplied(this.ignoreTagsIfNameMatches)) {
                gitChangelogApiBuilder.withIgnoreTagsIfNameMatches(this.ignoreTagsIfNameMatches);
            }
            SemanticVersion nextSemanticVersion = gitChangelogApiBuilder.getCurrentSemanticVersion();
            boolean notTagged = nextSemanticVersion.findTag().isEmpty();
            boolean suffixWithSnapshot = this.updatePomWithCurrentSemanticVersionSuffixSnapshot || this.updatePomWithCurrentSemanticVersionSuffixSnapshotIfNotTagged && notTagged;
            String nextVersion = suffixWithSnapshot ? nextSemanticVersion.getVersion() + "-SNAPSHOT" : nextSemanticVersion.getVersion();
            Model model = this.project.getModel();
            String versionOrig = model.getVersion();
            File pomFile = this.project.getFile();
            this.getLog().info((CharSequence)("Setting version to " + nextVersion + " was (" + versionOrig + ") in " + pomFile));
            model.setVersion(nextVersion);
            new XmlModifier(pomFile).setVersion(nextVersion);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean isSupplied(String param) {
        return param != null && !param.isEmpty();
    }
}

