/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.model.sarif;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.ViolationUtils;
import se.bjurr.violations.lib.model.generated.sarif.ArtifactLocation;
import se.bjurr.violations.lib.model.generated.sarif.Location;
import se.bjurr.violations.lib.model.generated.sarif.Message;
import se.bjurr.violations.lib.model.generated.sarif.PhysicalLocation;
import se.bjurr.violations.lib.model.generated.sarif.Region;
import se.bjurr.violations.lib.model.generated.sarif.Result;
import se.bjurr.violations.lib.model.generated.sarif.Run;
import se.bjurr.violations.lib.model.generated.sarif.SarifSchema;
import se.bjurr.violations.lib.model.generated.sarif.Tool;
import se.bjurr.violations.lib.model.generated.sarif.ToolComponent;

public class SarifTransformer {
    public static SarifSchema fromViolations(Set<Violation> from) {
        List<Path> allFiles = ViolationUtils.getAllFiles();
        List<Result> results = SarifTransformer.toResults(allFiles, from);
        Tool tool = SarifTransformer.toTool();
        Run run = new Run();
        run.setTool(tool);
        run.withResults(results);
        ArrayList<Run> runs = new ArrayList<Run>();
        runs.add(run);
        return new SarifSchema().withVersion("2.1.0").withRuns(runs);
    }

    private static Tool toTool() {
        TreeSet<Object> contents = new TreeSet<Object>();
        contents.add("nonLocalizedData");
        ToolComponent driver = new ToolComponent();
        driver.setName("Violations Lib");
        driver.setContents(contents);
        driver.setIsComprehensive(true);
        Tool tool = new Tool();
        tool.setDriver(driver);
        return tool;
    }

    private static List<Result> toResults(List<Path> allFiles, Set<Violation> from) {
        return from.stream().map(it -> SarifTransformer.transform(allFiles, it)).collect(Collectors.toList());
    }

    private static Result transform(List<Path> allFiles, Violation from) {
        String level = SarifTransformer.toLevel(from.getSeverity());
        Region region = new Region().withMessage(new Message().withText(from.getMessage())).withStartLine(SarifTransformer.zeroToOne(from.getStartLine())).withEndLine(SarifTransformer.zeroToOne(from.getEndLine())).withEndColumn(from.getEndColumn());
        ArtifactLocation artifactLocation = new ArtifactLocation().withUri(ViolationUtils.relativePath(allFiles, from));
        PhysicalLocation logicalLocations = new PhysicalLocation().withRegion(region).withArtifactLocation(artifactLocation);
        List<Location> locations = Arrays.asList(new Location().withPhysicalLocation(logicalLocations));
        return new Result().withRuleId(from.getRule()).withMessage(new Message().withText(from.getMessage())).withLevel(level).withLocations(locations).withKind("fail");
    }

    private static Integer zeroToOne(Integer startLine) {
        if (startLine == null || startLine == 0) {
            return 1;
        }
        return startLine;
    }

    private static String toLevel(SEVERITY severity) {
        if (severity == SEVERITY.ERROR) {
            return "error";
        }
        if (severity == SEVERITY.WARN) {
            return "warning";
        }
        return "none";
    }
}

