/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class FxCopParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String targetName = null;
            String typeName = null;
            String classname = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("Target")) {
                    targetName = ViolationParserUtils.getAttribute(xmlr, "Name").replaceAll("\\\\", "/");
                }
                if (xmlr.getLocalName().equalsIgnoreCase("Message")) {
                    typeName = ViolationParserUtils.getAttribute(xmlr, "TypeName");
                }
                if (xmlr.getLocalName().equalsIgnoreCase("Type")) {
                    classname = ViolationParserUtils.getAttribute(xmlr, "Name");
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("Issue")) continue;
                String level = ViolationParserUtils.getAttribute(xmlr, "Level");
                Optional<String> path = ViolationParserUtils.findAttribute(xmlr, "Path");
                if (!path.isPresent()) {
                    violationsLogger.log(Level.FINE, "Ignoring project level issue");
                    continue;
                }
                String fileName = ViolationParserUtils.getAttribute(xmlr, "File");
                Integer line = ViolationParserUtils.getIntegerAttribute(xmlr, "Line");
                String message = xmlr.getElementText().replaceAll("\\s+", " ");
                String filename = path.get() + "/" + fileName;
                SEVERITY severity = this.toSeverity(level);
                violations.add(Violation.violationBuilder().setParser(Parser.FXCOP).setMessage(message).setFile(filename).setStartLine(line).setRule(typeName).setSeverity(severity).setSource(classname).setSpecific("TARGET_NAME", targetName).build());
            }
        }
        return violations;
    }

    private SEVERITY toSeverity(String issueLevel) {
        if (issueLevel.contains("CriticalError")) {
            return SEVERITY.ERROR;
        }
        if (issueLevel.contains("Error")) {
            return SEVERITY.ERROR;
        }
        if (issueLevel.contains("CriticalWarning")) {
            return SEVERITY.WARN;
        }
        if (issueLevel.contains("Warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

