/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class GendarmeParser
implements ViolationsParser {
    private SEVERITY getSeverity(String severityString) {
        if (severityString.equalsIgnoreCase("Low")) {
            return SEVERITY.INFO;
        }
        if (severityString.equalsIgnoreCase("Medium")) {
            return SEVERITY.WARN;
        }
        if (severityString.equalsIgnoreCase("High")) {
            return SEVERITY.ERROR;
        }
        if (severityString.equalsIgnoreCase("Critical")) {
            return SEVERITY.ERROR;
        }
        return SEVERITY.WARN;
    }

    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String name = null;
            String problem = null;
            String solution = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("rule")) {
                    name = ViolationParserUtils.getAttribute(xmlr, "Name");
                }
                if (xmlr.getLocalName().equalsIgnoreCase("problem")) {
                    problem = xmlr.getElementText().trim();
                }
                if (xmlr.getLocalName().equalsIgnoreCase("solution")) {
                    solution = xmlr.getElementText().trim();
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("defect")) continue;
                String severityString = ViolationParserUtils.getAttribute(xmlr, "Severity");
                String source = ViolationParserUtils.getAttribute(xmlr, "Source");
                SEVERITY severity = this.getSeverity(severityString);
                String message = problem + "\n\n" + solution;
                Pattern pattern = Pattern.compile("^(.*)\\(.([0-9]*)\\)$");
                Matcher matcher = pattern.matcher(source);
                if (!matcher.matches()) continue;
                String filepath = matcher.group(1);
                Integer lineNumber = Integer.parseInt(matcher.group(2));
                Violation violation = Violation.violationBuilder().setParser(Parser.GENDARME).setFile(filepath).setMessage(message).setRule(name).setSeverity(severity).setStartLine(lineNumber).build();
                violations.add(violation);
            }
        }
        return violations;
    }
}

