/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class MSBuildLogParser
implements ViolationsParser {
    private static final String ParsingRegex = "^\\s*(.*)(\\(([0-9]*),([0-9]*)\\)|\\s):\\s([^\\s]*)\\s([^:]*):([^\\[]*)((\\[(.*)\\])?)$";
    private static final String[] MsBuildTargetFiles = new String[]{"Microsoft.Common.CurrentVersion.targets"};

    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(reportContent, ParsingRegex);
        for (List<String> parts : partsPerLine) {
            String projectFile = parts.get(10);
            String sourceFile = parts.get(1);
            boolean isMsBuildTarget = MSBuildLogParser.isMsBuildTarget(sourceFile);
            Integer lineNumber = 0;
            if (parts.get(3) != null && !parts.get(3).isEmpty() && !isMsBuildTarget) {
                lineNumber = Integer.parseInt(parts.get(3));
            }
            Integer columnNumber = 0;
            if (parts.get(4) != null && !parts.get(4).isEmpty() && !isMsBuildTarget) {
                columnNumber = Integer.parseInt(parts.get(4));
            }
            String severity = parts.get(5);
            String rule = parts.get(6);
            String message = parts.get(7).trim();
            violations.add(Violation.violationBuilder().setParser(Parser.MSBULDLOG).setStartLine(lineNumber).setColumn(columnNumber).setFile(isMsBuildTarget ? projectFile : sourceFile).setSeverity(this.toSeverity(severity)).setRule(rule).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (Utils.isNullOrEmpty(severity)) {
            return SEVERITY.INFO;
        }
        String lowerCase = severity.toLowerCase(Locale.ENGLISH);
        if (lowerCase.contains("low")) {
            return SEVERITY.INFO;
        }
        if (lowerCase.contains("error") || lowerCase.contains("c") || lowerCase.contains("high")) {
            return SEVERITY.ERROR;
        }
        if (lowerCase.contains("warning") || lowerCase.contains("w") || lowerCase.contains("medium")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }

    private static boolean isMsBuildTarget(String sourceName) {
        for (String target : MsBuildTargetFiles) {
            if (!sourceName.endsWith(target)) continue;
            return true;
        }
        return false;
    }
}

