/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class ResharperParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String content, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            HashMap issueTypesPerTypeId = new HashMap();
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("IssueType")) {
                    HashMap<String, String> issueType = new HashMap<String, String>();
                    String id = ViolationParserUtils.getAttribute(xmlr, "Id");
                    issueType.put("category", ViolationParserUtils.getAttribute(xmlr, "Category"));
                    Optional<String> description = ViolationParserUtils.findAttribute(xmlr, "Description");
                    issueType.put("description", !description.isPresent() || description.get().isEmpty() ? id : description.orElse(""));
                    issueType.put("severity", ViolationParserUtils.getAttribute(xmlr, "Severity"));
                    issueType.put("url", ViolationParserUtils.findAttribute(xmlr, "WikiUrl").orElse(null));
                    issueTypesPerTypeId.put(id, issueType);
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("Issue")) continue;
                String typeId = ViolationParserUtils.getAttribute(xmlr, "TypeId");
                String filename = ViolationParserUtils.getAttribute(xmlr, "File");
                String url = (String)((Map)issueTypesPerTypeId.get(typeId)).get("url");
                String message = ViolationParserUtils.findAttribute(xmlr, "Message").orElse("") + ". " + (String)((Map)issueTypesPerTypeId.get(typeId)).get("category") + ". " + (String)((Map)issueTypesPerTypeId.get(typeId)).get("description") + (url != null ? ". For more info, visit " + url : "");
                Integer line = ViolationParserUtils.findIntegerAttribute(xmlr, "Line").orElse(0);
                String severity = (String)((Map)issueTypesPerTypeId.get(typeId)).get("severity");
                Violation violation = Violation.violationBuilder().setParser(Parser.RESHARPER).setStartLine(line).setFile(filename).setSeverity(this.toSeverity(severity)).setMessage(message).setRule(typeId).build();
                violations.add(violation);
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("ERROR")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("WARNING")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

