/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.violationslib.com.google.gson.Gson;

public class SemgrepParser
implements ViolationsParser {
    @Override
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        LinkedHashSet<Violation> violations = new LinkedHashSet<Violation>();
        SemgrepReport report = new Gson().fromJson(reportContent, SemgrepReport.class);
        for (SemgrepResult result : report.results) {
            if (result.extra.is_ignored) continue;
            violations.add(Violation.violationBuilder().setParser(Parser.SEMGREP).setStartLine(result.start.line).setColumn(result.start.col).setEndLine(result.end.line).setEndColumn(result.end.col).setFile(result.path).setSeverity(result.extra.getSeverity()).setRule(result.check_id).setMessage(String.format("%s%n%n<p>%s</p>", result.extra.metadata.source, result.extra.message)).build());
        }
        return violations;
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    private static class Metadata {
        public String source;

        private Metadata() {
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    private static class Location {
        public int col;
        public int line;

        private Location() {
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    private static class Extra {
        public boolean is_ignored;
        public String message;
        public Metadata metadata;
        public String severity;

        private Extra() {
        }

        public SEVERITY getSeverity() {
            switch (this.severity) {
                case "WARNING": {
                    return SEVERITY.WARN;
                }
                case "ERROR": {
                    return SEVERITY.ERROR;
                }
            }
            return SEVERITY.INFO;
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    private static class SemgrepResult {
        public String check_id;
        public Location end;
        public Extra extra;
        public String path;
        public Location start;

        private SemgrepResult() {
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    private static class SemgrepReport {
        public List<SemgrepResult> results;

        private SemgrepReport() {
        }
    }
}

