/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.MissingObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.filter.RevFilter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.RawCharSequence;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.RawSubStringPattern;

public abstract class SubStringRevFilter
extends RevFilter {
    private final RawSubStringPattern pattern;

    public static boolean safe(String pattern) {
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected SubStringRevFilter(String patternText) {
        this.pattern = new RawSubStringPattern(patternText);
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.pattern.match(this.text(cmit)) >= 0;
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract RawCharSequence text(RevCommit var1);

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(\"" + this.pattern.pattern() + "\")";
    }
}

