/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.http.HttpConnection;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.http.NoCheckX509TrustManager;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.StringUtils;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.SystemReader;
import se.bjurr.violations.violationsgitlib.org.slf4j.Logger;
import se.bjurr.violations.violationsgitlib.org.slf4j.LoggerFactory;

public class HttpSupport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSupport.class);
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_POST = "POST";
    public static final String HDR_CACHE_CONTROL = "Cache-Control";
    public static final String HDR_PRAGMA = "Pragma";
    public static final String HDR_USER_AGENT = "User-Agent";
    public static final String HDR_SERVER = "Server";
    public static final String HDR_DATE = "Date";
    public static final String HDR_EXPIRES = "Expires";
    public static final String HDR_ETAG = "ETag";
    public static final String HDR_IF_NONE_MATCH = "If-None-Match";
    public static final String HDR_LAST_MODIFIED = "Last-Modified";
    public static final String HDR_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HDR_ACCEPT = "Accept";
    public static final String HDR_CONTENT_TYPE = "Content-Type";
    public static final String HDR_CONTENT_LENGTH = "Content-Length";
    public static final String HDR_CONTENT_ENCODING = "Content-Encoding";
    public static final String HDR_CONTENT_RANGE = "Content-Range";
    public static final String HDR_ACCEPT_RANGES = "Accept-Ranges";
    public static final String HDR_IF_RANGE = "If-Range";
    public static final String HDR_RANGE = "Range";
    public static final String HDR_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HDR_LOCATION = "Location";
    public static final String ENCODING_GZIP = "gzip";
    public static final String ENCODING_X_GZIP = "x-gzip";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String HDR_AUTHORIZATION = "Authorization";
    public static final String HDR_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String HDR_COOKIE = "Cookie";
    public static final String HDR_SET_COOKIE = "Set-Cookie";
    public static final String HDR_SET_COOKIE2 = "Set-Cookie2";
    private static Set<String> configuredHttpsProtocols;

    public static void encode(StringBuilder urlstr, String key) {
        if (key == null || key.length() == 0) {
            return;
        }
        try {
            urlstr.append(URLEncoder.encode(key, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(JGitText.get().couldNotURLEncodeToUTF8, e);
        }
    }

    public static String urlEncode(String url, boolean keepPathSlash) {
        String encoded;
        try {
            encoded = URLEncoder.encode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(JGitText.get().couldNotURLEncodeToUTF8, e);
        }
        if (keepPathSlash) {
            encoded = encoded.replace("%2F", "/");
        }
        return encoded;
    }

    public static int response(HttpConnection c) throws IOException {
        try {
            return c.getResponseCode();
        }
        catch (ConnectException ce) {
            String host;
            URL url = c.getURL();
            String string = host = url == null ? "<null>" : url.getHost();
            if ("Connection timed out: connect".equals(ce.getMessage())) {
                throw new ConnectException(MessageFormat.format(JGitText.get().connectionTimeOut, host));
            }
            throw new ConnectException(String.valueOf(ce.getMessage()) + " " + host);
        }
    }

    public static int response(HttpURLConnection c) throws IOException {
        try {
            return c.getResponseCode();
        }
        catch (ConnectException ce) {
            String host;
            URL url = c.getURL();
            String string = host = url == null ? "<null>" : url.getHost();
            if ("Connection timed out: connect".equals(ce.getMessage())) {
                throw new ConnectException(MessageFormat.format(JGitText.get().connectionTimeOut, host));
            }
            throw new ConnectException(String.valueOf(ce.getMessage()) + " " + host);
        }
    }

    public static String responseHeader(HttpConnection c, String headerName) throws IOException {
        return c.getHeaderField(headerName);
    }

    public static Proxy proxyFor(ProxySelector proxySelector, URL u) throws ConnectException {
        try {
            URI uri = new URI(u.getProtocol(), null, u.getHost(), u.getPort(), null, null, null);
            return proxySelector.select(uri).get(0);
        }
        catch (URISyntaxException e) {
            ConnectException err = new ConnectException(MessageFormat.format(JGitText.get().cannotDetermineProxyFor, u));
            err.initCause(e);
            throw err;
        }
    }

    public static void disableSslVerify(HttpConnection conn) throws IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new NoCheckX509TrustManager()};
        try {
            conn.configure(null, trustAllCerts, null);
            conn.setHostnameVerifier((name, session) -> true);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static void configureTLS(SSLSocket socket) {
        LinkedHashSet<String> enabled = new LinkedHashSet<String>(Arrays.asList(socket.getEnabledProtocols()));
        String[] stringArray = socket.getSupportedProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("TLS")) {
                enabled.add(s);
            }
            ++n2;
        }
        Set<String> configured = HttpSupport.getConfiguredProtocols();
        if (!configured.isEmpty()) {
            enabled.retainAll(configured);
        }
        if (!enabled.isEmpty()) {
            socket.setEnabledProtocols(enabled.toArray(new String[0]));
        }
    }

    private static Set<String> getConfiguredProtocols() {
        Set<String> result = configuredHttpsProtocols;
        if (result == null) {
            String configured = HttpSupport.getProperty("https.protocols");
            result = StringUtils.isEmptyOrNull(configured) ? Collections.emptySet() : new LinkedHashSet<String>(Arrays.asList(configured.split("\\s*,\\s*")));
            configuredHttpsProtocols = result;
        }
        return result;
    }

    private static String getProperty(String property) {
        try {
            return SystemReader.getInstance().getProperty(property);
        }
        catch (SecurityException e) {
            LOG.warn(JGitText.get().failedReadHttpsProtocols, e);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int scanToken(String header, int from) {
        length = header.length();
        i = from;
        if (i >= 0 && i <= length) ** GOTO lbl15
        throw new IndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            c = header.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '^': 
                case '_': 
                case '`': 
                case '|': 
                case '~': {
                    ++i;
                    break;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                        ++i;
                        break;
                    }
                    return i;
                }
            }
lbl15:
            // 3 sources

            ** while (i < length)
        }
lbl16:
        // 1 sources

        return i;
    }

    private HttpSupport() {
    }
}

