/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.git;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.git.PatchParser;
import se.bjurr.violations.git.ViolationsGitRepo;
import se.bjurr.violations.git.data.DiffsPerFile;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.util.Optional;

public class ViolationsGit {
    private final List<Violation> violations;

    public ViolationsGit(List<Violation> violations) {
        this.violations = violations;
    }

    public List<Violation> getViolationsInChangeset(File file, String from, String to) throws Exception {
        DiffsPerFile diffs = ViolationsGitRepo.diff(file, from, to);
        ArrayList<Violation> filtered = new ArrayList<Violation>();
        for (Violation candidate : this.violations) {
            Integer violatedLine;
            String patchString;
            Optional<Integer> lineOpt;
            Optional<String> patchStringOpt = diffs.findPatchString(candidate.getFile());
            if (!patchStringOpt.isPresent() || !(lineOpt = PatchParser.findLineInDiff(patchString = patchStringOpt.get(), violatedLine = candidate.getStartLine())).isPresent()) continue;
            filtered.add(candidate);
        }
        return filtered;
    }
}

