/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Optional;
import se.bjurr.violations.lib.util.Utils;

public class Violation
implements Serializable,
Comparable<Violation> {
    private static final long serialVersionUID = -6052921679385466168L;
    private Integer column;
    private final Integer endLine;
    private final String file;
    private final String message;
    private final Parser parser;
    private String reporter;
    private final String rule;
    private final SEVERITY severity;
    private final String source;
    private final Map<String, String> specifics;
    private final Integer startLine;

    public static ViolationBuilder violationBuilder() {
        return new ViolationBuilder();
    }

    public Violation() {
        this.startLine = null;
        this.endLine = null;
        this.severity = null;
        this.message = null;
        this.file = null;
        this.source = null;
        this.rule = null;
        this.reporter = null;
        this.specifics = null;
        this.parser = null;
    }

    public Violation(ViolationBuilder vb) {
        this.parser = Utils.checkNotNull(vb.parser, "reporter");
        this.reporter = vb.reporter != null && !vb.reporter.trim().isEmpty() ? vb.reporter : this.parser.name();
        this.startLine = Utils.checkNotNull(vb.startLine, "startline");
        this.endLine = Utils.firstNonNull(vb.endLine, vb.startLine);
        this.column = vb.column;
        this.severity = Utils.checkNotNull(vb.severity, "severity");
        this.message = Utils.checkNotNull(Utils.emptyToNull(vb.message), "message");
        this.file = Utils.checkNotNull(Utils.emptyToNull(vb.file), "file").replaceAll("\\\\", "/");
        this.source = Utils.emptyToNull(vb.source);
        this.rule = Utils.emptyToNull(vb.rule);
        this.specifics = vb.specifics;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Violation other = (Violation)obj;
        if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
            return false;
        }
        if (this.endLine == null ? other.endLine != null : !this.endLine.equals(other.endLine)) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.parser != other.parser) {
            return false;
        }
        if (this.reporter == null ? other.reporter != null : !this.reporter.equals(other.reporter)) {
            return false;
        }
        if (this.rule == null ? other.rule != null : !this.rule.equals(other.rule)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.specifics == null ? other.specifics != null : !this.specifics.equals(other.specifics)) {
            return false;
        }
        return !(this.startLine == null ? other.startLine != null : !this.startLine.equals(other.startLine));
    }

    public Optional<Integer> getColumn() {
        return Optional.fromNullable(this.column);
    }

    public Integer getEndLine() {
        return this.endLine;
    }

    public String getFile() {
        return this.file;
    }

    public String getMessage() {
        return this.message;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setReporter(String reporter) {
        this.reporter = Utils.checkNotNull(reporter, "reporter");
    }

    public String getReporter() {
        return this.reporter;
    }

    public Optional<String> getRule() {
        return Optional.fromNullable(this.rule);
    }

    public SEVERITY getSeverity() {
        return this.severity;
    }

    public Optional<String> getSource() {
        return Optional.fromNullable(this.source);
    }

    public Map<String, String> getSpecifics() {
        return this.specifics;
    }

    public Integer getStartLine() {
        return this.startLine;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        result = 31 * result + (this.endLine == null ? 0 : this.endLine.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.parser == null ? 0 : this.parser.hashCode());
        result = 31 * result + (this.reporter == null ? 0 : this.reporter.hashCode());
        result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.specifics == null ? 0 : this.specifics.hashCode());
        result = 31 * result + (this.startLine == null ? 0 : this.startLine.hashCode());
        return result;
    }

    public String toString() {
        return "Violation [column=" + this.column + ", endLine=" + this.endLine + ", file=" + this.file + ", message=" + this.message + ", reporter=" + (Object)((Object)this.parser) + ", rule=" + this.rule + ", severity=" + (Object)((Object)this.severity) + ", source=" + this.source + ", specifics=" + this.specifics + ", startLine=" + this.startLine + "]";
    }

    @Override
    public int compareTo(Violation o) {
        return this.comparingString(this).compareTo(this.comparingString(o));
    }

    private String comparingString(Violation o) {
        return o.file + "_" + (Integer.MAX_VALUE - o.getStartLine()) + "_" + (Object)((Object)o.getParser()) + "_" + o.getMessage();
    }

    public static class ViolationBuilder {
        private Integer column;
        private Integer endLine;
        private String file;
        private String message;
        private Parser parser;
        private String reporter;
        private String rule;
        private SEVERITY severity;
        private String source;
        private Map<String, String> specifics = new HashMap<String, String>();
        private Integer startLine;

        private ViolationBuilder() {
        }

        public Violation build() {
            return new Violation(this);
        }

        public ViolationBuilder setColumn(Integer column) {
            this.column = column;
            return this;
        }

        public ViolationBuilder setEndLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public ViolationBuilder setFile(String file) {
            this.file = file;
            return this;
        }

        public ViolationBuilder setMessage(String message) {
            this.message = message;
            return this;
        }

        public ViolationBuilder setParser(Parser parser) {
            this.parser = parser;
            return this;
        }

        public ViolationBuilder setReporter(String reporter) {
            this.reporter = reporter;
            return this;
        }

        public ViolationBuilder setRule(String rule) {
            this.rule = rule;
            return this;
        }

        public ViolationBuilder setSeverity(SEVERITY severity) {
            this.severity = severity;
            return this;
        }

        public ViolationBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public ViolationBuilder setSpecific(String specificsKey, Integer specificsValue) {
            this.specifics.put(specificsKey, Integer.toString(specificsValue));
            return this;
        }

        public ViolationBuilder setSpecific(String specificsKey, String specificsValue) {
            this.specifics.put(specificsKey, specificsValue);
            return this;
        }

        public ViolationBuilder setSpecifics(Map<String, String> specifics) {
            this.specifics = specifics;
            return this;
        }

        public ViolationBuilder setStartLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }
    }
}

